/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.fluo.accumulo.util.LongUtil;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.TransactorNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactorCache
implements AutoCloseable {
    private final Environment env;
    private final PathChildrenCache cache;
    private final Cache<Long, AtomicLong> timeoutCache = CacheBuilder.newBuilder().maximumSize(32768L).expireAfterAccess(1440L, TimeUnit.MINUTES).concurrencyLevel(10).build();
    private TcStatus status;
    private static final Logger log = LoggerFactory.getLogger(TransactorCache.class);

    public TransactorCache(Environment env) {
        this.env = env;
        this.cache = new PathChildrenCache(env.getSharedResources().getCurator(), "/transactor/nodes", true);
        try {
            this.cache.start(PathChildrenCache.StartMode.BUILD_INITIAL_CACHE);
            this.status = TcStatus.OPEN;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void logTimedoutTransactor(Long transactorId, long lockTs, Long startTime) {
        log.warn("Transactor ID {} was unresponsive for {} secs, marking as dead for lockTs <= {}", new Object[]{LongUtil.toMaxRadixString((Long)transactorId), (double)(System.currentTimeMillis() - startTime) / 1000.0, lockTs});
    }

    public void addTimedoutTransactor(final Long transactorId, final long lockTs, final Long startTime) {
        try {
            AtomicLong cachedLockTs = (AtomicLong)this.timeoutCache.get((Object)transactorId, (Callable)new Callable<AtomicLong>(){

                @Override
                public AtomicLong call() throws Exception {
                    TransactorCache.this.logTimedoutTransactor(transactorId, lockTs, startTime);
                    return new AtomicLong(lockTs);
                }
            });
            long currVal = cachedLockTs.get();
            while (lockTs > currVal) {
                if (cachedLockTs.compareAndSet(currVal, lockTs)) {
                    this.logTimedoutTransactor(transactorId, lockTs, startTime);
                }
                currVal = cachedLockTs.get();
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean checkTimedout(Long transactorId, long lockTs) {
        AtomicLong timedoutLockTs = (AtomicLong)this.timeoutCache.getIfPresent((Object)transactorId);
        return timedoutLockTs != null && lockTs <= timedoutLockTs.get();
    }

    public boolean checkExists(Long transactorId) {
        return this.cache.getCurrentData(TransactorNode.getNodePath(this.env, transactorId)) != null;
    }

    public TcStatus getStatus() {
        return this.status;
    }

    @Override
    public void close() {
        this.status = TcStatus.CLOSED;
        try {
            this.cache.close();
        }
        catch (IOException e) {
            log.error("Failed to close cache");
            throw new IllegalStateException(e);
        }
    }

    public static enum TcStatus {
        OPEN,
        CLOSED;

    }
}

