/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.apache.curator.framework.recipes.nodes.PersistentEphemeralNode;
import org.apache.fluo.accumulo.util.LongUtil;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.FluoConfigurationImpl;
import org.apache.fluo.core.impl.TransactorID;
import org.apache.fluo.core.oracle.Stamp;
import org.apache.fluo.core.util.CuratorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampTracker
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TimestampTracker.class);
    private volatile long zkTimestamp = -1L;
    private final Environment env;
    private final SortedSet<Long> timestamps = new TreeSet<Long>();
    private volatile PersistentEphemeralNode node = null;
    private final TransactorID tid;
    private final Timer timer;
    private boolean closed = false;
    private int allocationsInProgress = 0;
    private boolean updatingZk = false;

    public TimestampTracker(Environment env, TransactorID tid, long updatePeriodMs) {
        Objects.requireNonNull(env, "environment cannot be null");
        Objects.requireNonNull(tid, "tid cannot be null");
        Preconditions.checkArgument((updatePeriodMs > 0L ? 1 : 0) != 0, (Object)"update period must be positive");
        this.env = env;
        this.tid = tid;
        TimerTask tt = new TimerTask(){
            private int sawZeroCount = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block22: {
                    try {
                        long ts = 0L;
                        TimestampTracker timestampTracker = TimestampTracker.this;
                        synchronized (timestampTracker) {
                            if (TimestampTracker.this.closed) {
                                return;
                            }
                            if (TimestampTracker.this.allocationsInProgress > 0) {
                                this.sawZeroCount = 0;
                                if (TimestampTracker.this.timestamps.size() > 0) {
                                    if (TimestampTracker.this.updatingZk) {
                                        throw new IllegalStateException("expected updatingZk to be false");
                                    }
                                    ts = (Long)TimestampTracker.this.timestamps.first();
                                    TimestampTracker.this.updatingZk = true;
                                }
                            } else if (TimestampTracker.this.allocationsInProgress == 0) {
                                ++this.sawZeroCount;
                                if (this.sawZeroCount >= 2) {
                                    this.sawZeroCount = 0;
                                    TimestampTracker.this.closeZkNode();
                                }
                            } else {
                                throw new IllegalStateException("allocationsInProgress = " + TimestampTracker.this.allocationsInProgress);
                            }
                        }
                        if (!TimestampTracker.this.updatingZk) break block22;
                        try {
                            TimestampTracker.this.updateZkNode(ts);
                        }
                        finally {
                            timestampTracker = TimestampTracker.this;
                            synchronized (timestampTracker) {
                                TimestampTracker.this.updatingZk = false;
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("Exception occurred in Zookeeper update thread", (Throwable)e);
                    }
                }
            }
        };
        this.timer = new Timer("TimestampTracker timer", true);
        this.timer.schedule(tt, updatePeriodMs, updatePeriodMs);
    }

    public TimestampTracker(Environment env, TransactorID tid) {
        this(env, tid, env.getConfiguration().getLong("fluo.impl.timestamp.update.period", FluoConfigurationImpl.ZK_UPDATE_PERIOD_MS_DEFAULT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stamp allocateTimestamp() {
        TimestampTracker timestampTracker = this;
        synchronized (timestampTracker) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"tracker closed ");
            if (this.node == null) {
                Preconditions.checkState((this.allocationsInProgress == 0 ? 1 : 0) != 0, (Object)"expected allocationsInProgress == 0 when node == null");
                Preconditions.checkState((!this.updatingZk ? 1 : 0) != 0, (Object)"unexpected concurrent ZK update");
                this.createZkNode(this.getTimestamp().getTxTimestamp());
            }
            ++this.allocationsInProgress;
        }
        try {
            Stamp ts = this.getTimestamp();
            TimestampTracker timestampTracker2 = this;
            synchronized (timestampTracker2) {
                this.timestamps.add(ts.getTxTimestamp());
            }
            return ts;
        }
        catch (RuntimeException re) {
            TimestampTracker timestampTracker3 = this;
            synchronized (timestampTracker3) {
                --this.allocationsInProgress;
            }
            throw re;
        }
    }

    public synchronized void removeTimestamp(long ts) throws NoSuchElementException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"tracker closed ");
        Preconditions.checkState((this.allocationsInProgress > 0 ? 1 : 0) != 0, (Object)("allocationsInProgress should be > 0 " + this.allocationsInProgress));
        Objects.requireNonNull(this.node);
        if (!this.timestamps.remove(ts)) {
            throw new NoSuchElementException("Timestamp " + ts + " was previously removed or does not exist");
        }
        --this.allocationsInProgress;
    }

    private Stamp getTimestamp() {
        return this.env.getSharedResources().getOracleClient().getStamp();
    }

    private void createZkNode(long ts) {
        Preconditions.checkState((this.node == null ? 1 : 0) != 0, (Object)"expected node to be null");
        this.node = new PersistentEphemeralNode(this.env.getSharedResources().getCurator(), PersistentEphemeralNode.Mode.EPHEMERAL, this.getNodePath(), LongUtil.toByteArray((Long)ts));
        CuratorUtil.startAndWait(this.node, 10);
        this.zkTimestamp = ts;
    }

    private void closeZkNode() {
        try {
            if (this.node != null) {
                this.node.close();
                this.node = null;
            }
        }
        catch (IOException e) {
            log.error("Failed to close timestamp tracker ephemeral node");
            throw new IllegalStateException(e);
        }
    }

    private void updateZkNode(long ts) {
        if (ts != this.zkTimestamp) {
            try {
                this.node.setData(LongUtil.toByteArray((Long)ts));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        this.zkTimestamp = ts;
    }

    @VisibleForTesting
    public synchronized void updateZkNode() {
        Preconditions.checkState((!this.updatingZk ? 1 : 0) != 0, (Object)"unexpected concurrent ZK update");
        if (this.allocationsInProgress > 0) {
            if (this.timestamps.size() > 0) {
                this.updateZkNode(this.timestamps.first());
            }
        } else if (this.allocationsInProgress == 0) {
            this.closeZkNode();
        } else {
            throw new IllegalStateException("allocationsInProgress = " + this.allocationsInProgress);
        }
    }

    @VisibleForTesting
    public long getOldestActiveTimestamp() {
        return this.timestamps.first();
    }

    @VisibleForTesting
    public long getZookeeperTimestamp() {
        return this.zkTimestamp;
    }

    @VisibleForTesting
    public boolean isEmpty() {
        return this.timestamps.isEmpty();
    }

    @VisibleForTesting
    public String getNodePath() {
        return "/transactor/timestamps/" + this.tid.toString();
    }

    @Override
    public synchronized void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"tracker already closed");
        this.closed = true;
        this.timer.cancel();
        this.closeZkNode();
    }
}

