/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.accumulo.iterators.SnapshotIterator;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.api.data.Span;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.LockResolver;
import org.apache.fluo.core.impl.TxStats;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.SpanUtil;
import org.apache.fluo.core.util.UtilWaitThread;

public class SnapshotScanner
implements Iterable<Map.Entry<Key, Value>> {
    private final long startTs;
    private final Environment env;
    private final TxStats stats;
    private final Opts config;
    static final long INITIAL_WAIT_TIME = 50L;
    static final long MAX_WAIT_TIME = 60000L;

    static void setupScanner(ScannerBase scanner, Collection<Column> columns, long startTs) {
        for (Column col : columns) {
            if (col.isQualifierSet()) {
                scanner.fetchColumn(ByteUtil.toText(col.getFamily()), ByteUtil.toText(col.getQualifier()));
                continue;
            }
            scanner.fetchColumnFamily(ByteUtil.toText(col.getFamily()));
        }
        IteratorSetting iterConf = new IteratorSetting(10, SnapshotIterator.class);
        SnapshotIterator.setSnaptime((IteratorSetting)iterConf, (long)startTs);
        scanner.addScanIterator(iterConf);
    }

    SnapshotScanner(Environment env, Opts config, long startTs, TxStats stats) {
        this.env = env;
        this.config = config;
        this.startTs = startTs;
        this.stats = stats;
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        return new SnapIter(this.config);
    }

    private class SnapIter
    implements Iterator<Map.Entry<Key, Value>> {
        private Iterator<Map.Entry<Key, Value>> iterator;
        private Map.Entry<Key, Value> next;
        private Opts snapIterConfig;

        SnapIter(Opts config) {
            this.snapIterConfig = config;
            this.setUpIterator();
        }

        private void setUpIterator() {
            Scanner scanner;
            try {
                scanner = SnapshotScanner.this.env.getConnector().createScanner(SnapshotScanner.this.env.getTable(), SnapshotScanner.this.env.getAuthorizations());
            }
            catch (TableNotFoundException e) {
                throw new RuntimeException(e);
            }
            scanner.clearColumns();
            scanner.clearScanIterators();
            scanner.setRange(SpanUtil.toRange(this.snapIterConfig.getSpan()));
            SnapshotScanner.setupScanner((ScannerBase)scanner, this.snapIterConfig.getColumns(), SnapshotScanner.this.startTs);
            this.iterator = scanner.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                this.next = this.getNext();
            }
            return this.next != null;
        }

        @Override
        public Map.Entry<Key, Value> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<Key, Value> tmp = this.next;
            this.next = null;
            return tmp;
        }

        private void resetScanner(Span span) {
            this.snapIterConfig = new Opts(span, this.snapIterConfig.columns);
            this.setUpIterator();
        }

        public void resolveLock(Map.Entry<Key, Value> lockEntry) {
            long startTime = System.currentTimeMillis();
            long waitTime = 50L;
            ArrayList<Map.Entry<Key, Value>> locks = new ArrayList<Map.Entry<Key, Value>>();
            locks.add(lockEntry);
            int amountRead = 0;
            int numRead = 0;
            RowColumn origEnd = this.snapIterConfig.getSpan().getEnd();
            boolean isEndInclusive = this.snapIterConfig.getSpan().isEndInclusive();
            while (true) {
                boolean resolvedLocks;
                if (this.iterator.hasNext()) {
                    Map.Entry<Key, Value> entry = this.iterator.next();
                    long colType = entry.getKey().getTimestamp() & 0xE000000000000000L;
                    if (colType == -2305843009213693952L) {
                        locks.add(entry);
                    }
                    if (++numRead <= 100 && (amountRead += entry.getKey().getSize() + entry.getValue().getSize()) <= 4096) continue;
                }
                if (resolvedLocks = LockResolver.resolveLocks(SnapshotScanner.this.env, SnapshotScanner.this.startTs, SnapshotScanner.this.stats, locks, startTime)) break;
                UtilWaitThread.sleep(waitTime);
                SnapshotScanner.this.stats.incrementLockWaitTime(waitTime);
                waitTime = Math.min(60000L, waitTime * 2L);
                RowColumn start = SpanUtil.toRowColumn((Key)((Map.Entry)locks.get(0)).getKey());
                RowColumn end = SpanUtil.toRowColumn((Key)((Map.Entry)locks.get(locks.size() - 1)).getKey()).following();
                this.resetScanner(new Span(start, true, end, false));
                locks.clear();
            }
            RowColumn start = SpanUtil.toRowColumn(lockEntry.getKey());
            this.resetScanner(new Span(start, true, origEnd, isEndInclusive));
        }

        public Map.Entry<Key, Value> getNext() {
            long colType;
            Map.Entry<Key, Value> entry;
            while (true) {
                if (!this.iterator.hasNext()) {
                    return null;
                }
                entry = this.iterator.next();
                colType = entry.getKey().getTimestamp() & 0xE000000000000000L;
                if (colType != -2305843009213693952L) break;
                this.resolveLock(entry);
            }
            if (colType == -6917529027641081856L) {
                SnapshotScanner.this.stats.incrementEntriesReturned(1L);
                return entry;
            }
            throw new IllegalArgumentException("Unexpected column type " + colType);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    public static final class Opts {
        private final Span span;
        private final Collection<Column> columns;

        public Opts(Span span, Collection<Column> columns) {
            this.span = span;
            this.columns = ImmutableSet.copyOf(columns);
        }

        public Span getSpan() {
            return this.span;
        }

        public Collection<Column> getColumns() {
            return this.columns;
        }
    }
}

