/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.ConditionalWriterConfig;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.curator.framework.CuratorFramework;
import org.apache.fluo.core.async.AsyncConditionalWriter;
import org.apache.fluo.core.async.CommitManager;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.FluoConfigurationImpl;
import org.apache.fluo.core.impl.SharedBatchWriter;
import org.apache.fluo.core.impl.TimestampTracker;
import org.apache.fluo.core.impl.TransactorCache;
import org.apache.fluo.core.impl.TransactorID;
import org.apache.fluo.core.impl.TransactorNode;
import org.apache.fluo.core.impl.TxInfoCache;
import org.apache.fluo.core.impl.VisibilityCache;
import org.apache.fluo.core.oracle.OracleClient;
import org.apache.fluo.core.util.CuratorUtil;
import org.apache.fluo.core.util.FluoExecutors;

public class SharedResources
implements AutoCloseable {
    private final Environment env;
    private final BatchWriter bw;
    private final ConditionalWriter cw;
    private final ConditionalWriter bulkCw;
    private final SharedBatchWriter sbw;
    private final CuratorFramework curator;
    private OracleClient oracleClient = null;
    private TransactorID tid = null;
    private TransactorNode tnode = null;
    private TransactorCache transactorCache = null;
    private TimestampTracker tsTracker = null;
    private volatile boolean isClosed = false;
    private final TxInfoCache txInfoCache;
    private final VisibilityCache visCache;
    private final MetricRegistry metricRegistry;
    private AsyncConditionalWriter acw;
    private AsyncConditionalWriter bulkAcw;
    private ExecutorService asyncCommitExecutor;
    private ExecutorService syncCommitExecutor;
    private CommitManager commitManager;

    public SharedResources(Environment env) throws TableNotFoundException {
        this.env = env;
        this.curator = CuratorUtil.newAppCurator(env.getConfiguration());
        this.curator.start();
        int numTservers = env.getConnector().instanceOperations().getTabletServers().size();
        int numBWThreads = FluoConfigurationImpl.getNumBWThreads(env.getConfiguration(), numTservers);
        this.bw = env.getConnector().createBatchWriter(env.getTable(), new BatchWriterConfig().setMaxWriteThreads(numBWThreads));
        this.sbw = new SharedBatchWriter(this.bw);
        int numCWThreads = FluoConfigurationImpl.getNumCWThreads(env.getConfiguration(), numTservers);
        this.cw = env.getConnector().createConditionalWriter(env.getTable(), new ConditionalWriterConfig().setAuthorizations(env.getAuthorizations()).setMaxWriteThreads(numCWThreads));
        this.bulkCw = env.getConnector().createConditionalWriter(env.getTable(), new ConditionalWriterConfig().setAuthorizations(env.getAuthorizations()).setMaxWriteThreads(numCWThreads));
        this.txInfoCache = new TxInfoCache(env);
        this.visCache = new VisibilityCache();
        this.metricRegistry = new MetricRegistry();
        int commitThreads = env.getConfiguration().getInt("fluo.impl.tx.commit.threads.async", 8);
        this.asyncCommitExecutor = FluoExecutors.newFixedThreadPool(commitThreads, "async-commits");
        commitThreads = env.getConfiguration().getInt("fluo.impl.tx.commit.threads.sync", 32);
        this.syncCommitExecutor = FluoExecutors.newFixedThreadPool(commitThreads, "sync-commits");
        this.acw = new AsyncConditionalWriter(env, this.cw);
        this.bulkAcw = new AsyncConditionalWriter(env, this.bulkCw);
    }

    public SharedBatchWriter getBatchWriter() {
        this.checkIfClosed();
        return this.sbw;
    }

    public ConditionalWriter getConditionalWriter() {
        this.checkIfClosed();
        return this.cw;
    }

    public TxInfoCache getTxInfoCache() {
        this.checkIfClosed();
        return this.txInfoCache;
    }

    public CuratorFramework getCurator() {
        this.checkIfClosed();
        return this.curator;
    }

    public synchronized OracleClient getOracleClient() {
        this.checkIfClosed();
        if (this.oracleClient == null) {
            this.oracleClient = new OracleClient(this.env);
        }
        return this.oracleClient;
    }

    public synchronized TransactorID getTransactorID() {
        this.checkIfClosed();
        if (this.tid == null) {
            this.tid = new TransactorID(this.env);
        }
        return this.tid;
    }

    public synchronized TimestampTracker getTimestampTracker() {
        this.checkIfClosed();
        if (this.tsTracker == null) {
            this.tsTracker = new TimestampTracker(this.env, this.getTransactorID());
        }
        return this.tsTracker;
    }

    public synchronized TransactorNode getTransactorNode() {
        this.checkIfClosed();
        if (this.tnode == null) {
            this.tnode = new TransactorNode(this.env, this.getTransactorID());
        } else if (this.tnode.getStatus() == TransactorNode.TrStatus.CLOSED) {
            throw new IllegalStateException("TransactorNode is closed!");
        }
        return this.tnode;
    }

    public synchronized TransactorCache getTransactorCache() {
        this.checkIfClosed();
        if (this.transactorCache == null) {
            this.transactorCache = new TransactorCache(this.env);
        } else if (this.transactorCache.getStatus() == TransactorCache.TcStatus.CLOSED) {
            throw new IllegalStateException("TransactorCache is closed!");
        }
        return this.transactorCache;
    }

    public VisibilityCache getVisCache() {
        this.checkIfClosed();
        return this.visCache;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public synchronized void close() {
        this.isClosed = true;
        if (this.commitManager != null) {
            this.commitManager.close();
        }
        this.asyncCommitExecutor.shutdownNow();
        try {
            this.asyncCommitExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        this.syncCommitExecutor.shutdownNow();
        try {
            this.syncCommitExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        if (this.tnode != null) {
            this.tnode.close();
        }
        if (this.tsTracker != null) {
            this.tsTracker.close();
        }
        if (this.transactorCache != null) {
            this.transactorCache.close();
        }
        if (this.oracleClient != null) {
            this.oracleClient.close();
        }
        this.acw.close();
        this.cw.close();
        this.bulkAcw.close();
        this.bulkCw.close();
        this.sbw.close();
        try {
            this.bw.close();
        }
        catch (MutationsRejectedException e) {
            throw new RuntimeException(e);
        }
        this.curator.close();
    }

    private void checkIfClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("SharedResources is closed!");
        }
    }

    public Executor getSyncCommitExecutor() {
        return this.syncCommitExecutor;
    }

    public Executor getAsyncCommitExecutor() {
        return this.asyncCommitExecutor;
    }

    public AsyncConditionalWriter getAsyncConditionalWriter() {
        return this.acw;
    }

    public AsyncConditionalWriter getBulkAsyncConditionalWriter() {
        return this.bulkAcw;
    }

    public synchronized CommitManager getCommitManager() {
        this.checkIfClosed();
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this.env);
        }
        return this.commitManager;
    }
}

