/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.accumulo.values.LockValue;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.util.Hex;

class PrimaryRowColumn {
    Bytes prow;
    Column pcol;
    long startTs;

    public PrimaryRowColumn(Bytes prow, Column pcol, long startTs) {
        this.prow = prow;
        this.pcol = pcol;
        this.startTs = startTs;
    }

    public PrimaryRowColumn(Map.Entry<Key, Value> lock) {
        LockValue lv = new LockValue(lock.getValue().get());
        this.prow = lv.getPrimaryRow();
        this.pcol = lv.getPrimaryColumn();
        this.startTs = lock.getKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
    }

    public int weight() {
        return 32 + this.prow.length() + this.pcol.getFamily().length() + this.pcol.getQualifier().length() + this.pcol.getVisibility().length();
    }

    public boolean equals(Object o) {
        if (o instanceof PrimaryRowColumn) {
            PrimaryRowColumn ock = (PrimaryRowColumn)o;
            return this.prow.equals((Object)ock.prow) && this.pcol.equals((Object)ock.pcol) && this.startTs == ock.startTs;
        }
        return false;
    }

    public int hashCode() {
        return this.prow.hashCode() + this.pcol.hashCode() + Long.valueOf(this.startTs).hashCode();
    }

    public String toString() {
        return Hex.encNonAscii(this.prow) + " " + Hex.encNonAscii(this.pcol) + " " + this.startTs;
    }
}

