/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.LockResolver;
import org.apache.fluo.core.impl.SnapshotScanner;
import org.apache.fluo.core.impl.TxStats;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.UtilWaitThread;
import org.apache.hadoop.io.Text;

public class ParallelSnapshotScanner {
    private Environment env;
    private long startTs;
    private Collection<Bytes> rows;
    private Set<Column> columns;
    private TxStats stats;
    private List<Range> rangesToScan = new ArrayList<Range>();

    ParallelSnapshotScanner(Collection<Bytes> rows, Set<Column> columns, Environment env, long startTs, TxStats stats) {
        this.rows = rows;
        this.columns = columns;
        this.env = env;
        this.startTs = startTs;
        this.stats = stats;
    }

    ParallelSnapshotScanner(Collection<RowColumn> cells, Environment env, long startTs, TxStats stats) {
        for (RowColumn rc : cells) {
            byte[] r = rc.getRow().toArray();
            byte[] cf = rc.getColumn().getFamily().toArray();
            byte[] cq = rc.getColumn().getQualifier().toArray();
            byte[] cv = rc.getColumn().getVisibility().toArray();
            Key start = new Key(r, cf, cq, cv, Long.MAX_VALUE, false, false);
            Key end = new Key(start);
            end.setTimestamp(Long.MIN_VALUE);
            this.rangesToScan.add(new Range(start, true, end, true));
        }
        this.rows = null;
        this.env = env;
        this.startTs = startTs;
        this.stats = stats;
    }

    private BatchScanner setupBatchScanner() {
        BatchScanner scanner;
        try {
            scanner = this.env.getConnector().createBatchScanner(this.env.getTable(), this.env.getAuthorizations(), 1);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        scanner.clearColumns();
        scanner.clearScanIterators();
        if (this.rangesToScan.size() > 0) {
            scanner.setRanges(this.rangesToScan);
            SnapshotScanner.setupScanner((ScannerBase)scanner, Collections.emptySet(), this.startTs);
        } else if (this.rows != null) {
            ArrayList<Range> ranges = new ArrayList<Range>(this.rows.size());
            for (Bytes row : this.rows) {
                ranges.add(Range.exact((Text)ByteUtil.toText(row)));
            }
            scanner.setRanges(ranges);
            SnapshotScanner.setupScanner((ScannerBase)scanner, this.columns, this.startTs);
        } else {
            return null;
        }
        return scanner;
    }

    Map<Bytes, Map<Column, Bytes>> scan() {
        long waitTime = 50L;
        long startTime = System.currentTimeMillis();
        HashMap<Bytes, Map<Column, Bytes>> ret = new HashMap<Bytes, Map<Column, Bytes>>();
        block0: while (true) {
            ArrayList<Map.Entry<Key, Value>> locks = new ArrayList<Map.Entry<Key, Value>>();
            this.scan(ret, locks);
            if (locks.size() <= 0) break;
            boolean resolvedAll = LockResolver.resolveLocks(this.env, this.startTs, this.stats, locks, startTime);
            if (!resolvedAll) {
                UtilWaitThread.sleep(waitTime);
                this.stats.incrementLockWaitTime(waitTime);
                waitTime = Math.min(60000L, waitTime * 2L);
            }
            this.rangesToScan.clear();
            this.rows = null;
            Iterator iterator = locks.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block0;
                Map.Entry entry = (Map.Entry)iterator.next();
                Key start = new Key((Key)entry.getKey());
                start.setTimestamp(Long.MAX_VALUE);
                Key end = new Key((Key)entry.getKey());
                end.setTimestamp(Long.MIN_VALUE);
                this.rangesToScan.add(new Range(start, true, end, true));
            }
            break;
        }
        for (Map cols : ret.values()) {
            this.stats.incrementEntriesReturned(cols.size());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan(Map<Bytes, Map<Column, Bytes>> ret, List<Map.Entry<Key, Value>> locks) {
        try (BatchScanner bs = this.setupBatchScanner();){
            for (Map.Entry entry : bs) {
                Bytes row = ByteUtil.toBytes(((Key)entry.getKey()).getRowData());
                Bytes cf = ByteUtil.toBytes(((Key)entry.getKey()).getColumnFamilyData());
                Bytes cq = ByteUtil.toBytes(((Key)entry.getKey()).getColumnQualifierData());
                Column col = new Column(cf, cq, ByteUtil.toBytes(((Key)entry.getKey()).getColumnVisibilityData()));
                long colType = ((Key)entry.getKey()).getTimestamp() & 0xE000000000000000L;
                if (colType == -2305843009213693952L) {
                    locks.add(entry);
                    continue;
                }
                if (colType == -6917529027641081856L) {
                    Map<Column, Bytes> cols = ret.get(row);
                    if (cols == null) {
                        cols = new HashMap<Column, Bytes>();
                        ret.put(row, cols);
                    }
                    cols.put(col, Bytes.of((byte[])((Value)entry.getValue()).get()));
                    continue;
                }
                throw new IllegalArgumentException("Unexpected column type " + colType);
            }
        }
    }
}

