/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.base.Preconditions;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.fluo.accumulo.iterators.NotificationIterator;
import org.apache.fluo.accumulo.util.ColumnConstants;
import org.apache.fluo.accumulo.util.NotificationUtil;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.TransactionImpl;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.Flutation;

public class Notification {
    private final RowColumn rowCol;
    private final long timestamp;

    public Notification(Bytes row, Column col, long ts) {
        this.rowCol = new RowColumn(row, col);
        this.timestamp = ts;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Bytes getRow() {
        return this.rowCol.getRow();
    }

    public Column getColumn() {
        return this.rowCol.getColumn();
    }

    public RowColumn getRowColumn() {
        return this.rowCol;
    }

    public Flutation newDelete(Environment env) {
        return this.newDelete(env, this.getTimestamp());
    }

    public Flutation newDelete(Environment env, long ts) {
        Flutation m = new Flutation(env, this.rowCol.getRow());
        ColumnVisibility cv = env.getSharedResources().getVisCache().getCV(this.rowCol.getColumn());
        m.put(ColumnConstants.NOTIFY_CF.toArray(), NotificationUtil.encodeCol((Column)this.rowCol.getColumn()), cv, NotificationUtil.encodeTs((long)ts, (boolean)true), TransactionImpl.EMPTY);
        return m;
    }

    public static void put(Environment env, Mutation m, Column col, long ts) {
        ColumnVisibility cv = env.getSharedResources().getVisCache().getCV(col);
        m.put(ColumnConstants.NOTIFY_CF.toArray(), NotificationUtil.encodeCol((Column)col), cv, NotificationUtil.encodeTs((long)ts, (boolean)false), TransactionImpl.EMPTY);
    }

    public static Notification from(Key k) {
        Preconditions.checkArgument((!NotificationUtil.isDelete((Key)k) ? 1 : 0) != 0, (Object)"Method not expected to be used with delete notifications");
        Bytes row = ByteUtil.toBytes(k.getRowData());
        return new Notification(row, NotificationUtil.decodeCol((Key)k), NotificationUtil.decodeTs((Key)k));
    }

    public static void configureScanner(Scanner scanner) {
        scanner.fetchColumnFamily(ByteUtil.toText(ColumnConstants.NOTIFY_CF));
        scanner.addScanIterator(new IteratorSetting(11, NotificationIterator.class));
    }
}

