/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ConditionalWriter;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.ConditionalMutation;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.accumulo.iterators.PrewriteIterator;
import org.apache.fluo.accumulo.values.DelLockValue;
import org.apache.fluo.accumulo.values.LockValue;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.PrimaryRowColumn;
import org.apache.fluo.core.impl.TransactorCache;
import org.apache.fluo.core.impl.TxInfo;
import org.apache.fluo.core.impl.TxInfoCache;
import org.apache.fluo.core.impl.TxStats;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.ColumnUtil;
import org.apache.fluo.core.util.ConditionalFlutation;
import org.apache.fluo.core.util.FluoCondition;
import org.apache.fluo.core.util.SpanUtil;

public class LockResolver {
    private static Map<PrimaryRowColumn, List<Map.Entry<Key, Value>>> groupLocksByPrimary(List<Map.Entry<Key, Value>> locks) {
        HashMap<PrimaryRowColumn, List<Map.Entry<Key, Value>>> groupedLocks = new HashMap<PrimaryRowColumn, List<Map.Entry<Key, Value>>>();
        HashMap<PrimaryRowColumn, Long> transactorIds = new HashMap<PrimaryRowColumn, Long>();
        for (Map.Entry<Key, Value> lock : locks) {
            Long trid;
            LockValue lockVal = new LockValue(lock.getValue().get());
            PrimaryRowColumn prc = new PrimaryRowColumn(lockVal.getPrimaryRow(), lockVal.getPrimaryColumn(), lock.getKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL);
            ArrayList<Map.Entry<Key, Value>> lockList = (ArrayList<Map.Entry<Key, Value>>)groupedLocks.get(prc);
            if (lockList == null) {
                lockList = new ArrayList<Map.Entry<Key, Value>>();
                groupedLocks.put(prc, lockList);
            }
            if ((trid = (Long)transactorIds.get(prc)) == null) {
                transactorIds.put(prc, lockVal.getTransactor());
            } else if (!trid.equals(lockVal.getTransactor())) {
                throw new IllegalStateException("transactor ids not equals " + prc + " " + lock.getKey() + " " + trid + " " + lockVal.getTransactor());
            }
            lockList.add(lock);
        }
        return groupedLocks;
    }

    static boolean resolveLocks(Environment env, long startTs, TxStats stats, List<Map.Entry<Key, Value>> locks, long startTime) {
        List<Map.Entry<Key, Value>> locksToRecover;
        int numResolved = 0;
        HashMap<ByteSequence, Mutation> mutations = new HashMap<ByteSequence, Mutation>();
        boolean timedOut = false;
        TransactorCache transactorCache = env.getSharedResources().getTransactorCache();
        if (System.currentTimeMillis() - startTime > env.getConfiguration().getTransactionRollbackTime()) {
            locksToRecover = locks;
            stats.incrementTimedOutLocks(locksToRecover.size());
            timedOut = true;
        } else {
            locksToRecover = new ArrayList<Map.Entry<Key, Value>>(locks.size());
            for (Map.Entry<Key, Value> entry : locks) {
                long lockTs;
                Long transactorId = new LockValue(entry.getValue().get()).getTransactor();
                if (transactorCache.checkTimedout(transactorId, lockTs = entry.getKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL)) {
                    locksToRecover.add(entry);
                    stats.incrementTimedOutLocks();
                    continue;
                }
                if (transactorCache.checkExists(transactorId)) continue;
                locksToRecover.add(entry);
                stats.incrementDeadLocks();
            }
        }
        Map<PrimaryRowColumn, List<Map.Entry<Key, Value>>> groupedLocks = LockResolver.groupLocksByPrimary(locksToRecover);
        if (timedOut) {
            Set<Map.Entry<PrimaryRowColumn, List<Map.Entry<Key, Value>>>> es = groupedLocks.entrySet();
            for (Map.Entry<PrimaryRowColumn, List<Map.Entry<Key, Value>>> entry : es) {
                long lockTs = entry.getKey().startTs;
                Long transactorId = new LockValue(entry.getValue().get(0).getValue().get()).getTransactor();
                transactorCache.addTimedoutTransactor(transactorId, lockTs, startTime);
            }
        }
        TxInfoCache txiCache = env.getSharedResources().getTxInfoCache();
        Set<Map.Entry<PrimaryRowColumn, List<Map.Entry<Key, Value>>>> es = groupedLocks.entrySet();
        block7: for (Map.Entry<PrimaryRowColumn, List<Map.Entry<Key, Value>>> group : es) {
            TxInfo txInfo = txiCache.getTransactionInfo(group.getKey());
            switch (txInfo.status) {
                case COMMITTED: {
                    LockResolver.commitColumns(env, group.getKey(), group.getValue(), txInfo.commitTs, mutations);
                    numResolved += group.getValue().size();
                    continue block7;
                }
                case LOCKED: {
                    if (!LockResolver.rollbackPrimary(env, startTs, group.getKey(), txInfo.lockValue)) continue block7;
                    LockResolver.rollback(env, startTs, group.getKey(), group.getValue(), mutations);
                    numResolved += group.getValue().size();
                    continue block7;
                }
                case ROLLED_BACK: {
                    LockResolver.rollback(env, startTs, group.getKey(), group.getValue(), mutations);
                    numResolved += group.getValue().size();
                    continue block7;
                }
            }
            throw new IllegalStateException("can not abort : " + group.getKey() + " (" + (Object)((Object)txInfo.status) + ")");
        }
        if (mutations.size() > 0) {
            env.getSharedResources().getBatchWriter().writeMutations(new ArrayList<Mutation>(mutations.values()));
        }
        return numResolved == locks.size();
    }

    private static void rollback(Environment env, long startTs, PrimaryRowColumn prc, List<Map.Entry<Key, Value>> value, Map<ByteSequence, Mutation> mutations) {
        for (Map.Entry<Key, Value> entry : value) {
            if (LockResolver.isPrimary(prc, entry.getKey())) continue;
            long lockTs = entry.getKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
            Mutation mut = LockResolver.getMutation(entry.getKey().getRowData(), mutations);
            Key k = entry.getKey();
            mut.put(k.getColumnFamilyData().toArray(), k.getColumnQualifierData().toArray(), k.getColumnVisibilityParsed(), 0x2000000000000000L | lockTs, DelLockValue.encodeRollback((boolean)false, (boolean)true));
        }
    }

    private static boolean rollbackPrimary(Environment env, long startTs, PrimaryRowColumn prc, byte[] lockValue) {
        IteratorSetting iterConf = new IteratorSetting(10, PrewriteIterator.class);
        PrewriteIterator.setSnaptime((IteratorSetting)iterConf, (long)startTs);
        ConditionalFlutation delLockMutation = new ConditionalFlutation(env, prc.prow, new FluoCondition(env, prc.pcol).setIterators(new IteratorSetting[]{iterConf}).setValue(lockValue));
        delLockMutation.put(prc.pcol, 0x2000000000000000L | prc.startTs, DelLockValue.encodeRollback((boolean)true, (boolean)true));
        ConditionalWriter cw = null;
        cw = env.getSharedResources().getConditionalWriter();
        try {
            return cw.write((ConditionalMutation)delLockMutation).getStatus() == ConditionalWriter.Status.ACCEPTED;
        }
        catch (AccumuloException e) {
            throw new RuntimeException(e);
        }
        catch (AccumuloSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static void commitColumns(Environment env, PrimaryRowColumn prc, List<Map.Entry<Key, Value>> value, long commitTs, Map<ByteSequence, Mutation> mutations) {
        for (Map.Entry<Key, Value> entry : value) {
            if (LockResolver.isPrimary(prc, entry.getKey())) continue;
            long lockTs = entry.getKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
            if (commitTs < lockTs) {
                throw new IllegalStateException("bad commitTs : " + entry.getKey() + " (" + commitTs + "<" + lockTs + ")");
            }
            Mutation mut = LockResolver.getMutation(entry.getKey().getRowData(), mutations);
            Column col = SpanUtil.toRowColumn(entry.getKey()).getColumn();
            LockValue lv = new LockValue(entry.getValue().get());
            ColumnUtil.commitColumn(env, lv.isTrigger(), false, col, lv.isWrite(), lv.isDelete(), lockTs, commitTs, env.getObservers().keySet(), mut);
        }
    }

    private static Mutation getMutation(ByteSequence row, Map<ByteSequence, Mutation> mutations) {
        Mutation mut = mutations.get(row);
        if (mut == null) {
            mut = new Mutation(row.toArray());
            mutations.put(row, mut);
        }
        return mut;
    }

    private static boolean isPrimary(PrimaryRowColumn prc, Key k) {
        return prc.prow.equals((Object)ByteUtil.toBytes(k.getRowData())) && prc.pcol.equals((Object)SpanUtil.toRowColumn(k).getColumn());
    }
}

