/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.core.worker.finder.hash.ScanTask;

public class FluoConfigurationImpl {
    public static final String FLUO_IMPL_PREFIX = "fluo.impl";
    public static final String ORACLE_PORT_PROP = "fluo.impl.oracle.port";
    public static final String WORKER_FINDER_PROP = "fluo.impl.worker.finder";
    public static final String METRICS_RESERVOIR_PROP = "fluo.impl.metrics.reservoir";
    public static final String MIN_SLEEP_TIME_PROP = "fluo.impl" + ScanTask.class.getSimpleName() + ".minSleep";
    public static final int MIN_SLEEP_TIME_DEFAULT = 5000;
    public static final String MAX_SLEEP_TIME_PROP = "fluo.impl" + ScanTask.class.getSimpleName() + ".maxSleep";
    public static final int MAX_SLEEP_TIME_DEFAULT = 300000;
    public static final String ZK_UPDATE_PERIOD_PROP = "fluo.impl.timestamp.update.period";
    public static long ZK_UPDATE_PERIOD_MS_DEFAULT = 60000L;
    public static final String CW_MIN_THREADS_PROP = "fluo.impl.cw.threads.min";
    public static final int CW_MIN_THREADS_DEFAULT = 3;
    public static final String CW_MAX_THREADS_PROP = "fluo.impl.cw.threads.max";
    public static final int CW_MAX_THREADS_DEFAULT = 20;
    public static final String BW_MIN_THREADS_PROP = "fluo.impl.bw.threads.min";
    public static final int BW_MIN_THREADS_DEFAULT = 3;
    public static final String BW_MAX_THREADS_PROP = "fluo.impl.bw.threads.max";
    public static final int BW_MAX_THREADS_DEFAULT = 20;
    public static final String COMMIT_MEMORY_PROP = "fluo.impl.tx.commit.memory";
    public static final int COMMIT_MEMORY_DEFAULT = 0x1400000;
    public static final String ASYNC_CW_THREADS = "fluo.impl.async.cw.threads";
    public static final int ASYNC_CW_THREADS_DEFAULT = 8;
    public static final String ASYNC_CW_LIMIT = "fluo.impl.async.cw.limit";
    public static final int ASYNC_CW_LIMIT_DEFAULT = 100000;
    public static final String ASYNC_COMMIT_THREADS = "fluo.impl.tx.commit.threads.async";
    public static final int ASYNC_COMMIT_THREADS_DEFAULT = 8;
    public static final String SYNC_COMMIT_THREADS = "fluo.impl.tx.commit.threads.sync";
    public static final int SYNC_COMMIT_THREADS_DEFAULT = 32;

    public static int getNumCWThreads(FluoConfiguration conf, int numTservers) {
        int min = conf.getInt(CW_MIN_THREADS_PROP, 3);
        int max = conf.getInt(CW_MAX_THREADS_PROP, 20);
        if (min < 0 || max < 0 || min > max) {
            throw new IllegalArgumentException("Bad conditional writer thread props " + min + " " + max);
        }
        int numThreads = numTservers;
        numThreads = Math.min(numThreads, max);
        numThreads = Math.max(numThreads, min);
        return numThreads;
    }

    public static int getNumBWThreads(FluoConfiguration conf, int numTservers) {
        int min = conf.getInt(BW_MIN_THREADS_PROP, 3);
        int max = conf.getInt(BW_MAX_THREADS_PROP, 20);
        if (min < 0 || max < 0 || min > max) {
            throw new IllegalArgumentException("Bad batch writer thread props " + min + " " + max);
        }
        int numThreads = numTservers;
        numThreads = Math.min(numThreads, max);
        numThreads = Math.max(numThreads, min);
        return numThreads;
    }

    public static int getTxCommitMemory(FluoConfiguration conf) {
        int m = conf.getInt(COMMIT_MEMORY_PROP, 0x1400000);
        if (m <= 0) {
            throw new IllegalArgumentException("Bad value for fluo.impl.tx.commit.memory " + m);
        }
        return m;
    }
}

