/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.curator.framework.CuratorFramework;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.metrics.MetricsReporter;
import org.apache.fluo.core.impl.SharedResources;
import org.apache.fluo.core.metrics.MetricNames;
import org.apache.fluo.core.metrics.MetricsReporterImpl;
import org.apache.fluo.core.util.AccumuloUtil;
import org.apache.fluo.core.util.ColumnUtil;
import org.apache.fluo.core.util.CuratorUtil;
import org.apache.hadoop.io.WritableUtils;

public class Environment
implements AutoCloseable {
    private String table;
    private Authorizations auths = new Authorizations();
    private String accumuloInstance;
    private Map<Column, ObserverSpecification> observers;
    private Map<Column, ObserverSpecification> weakObservers;
    private Set<Column> allObserversColumns;
    private Connector conn;
    private String accumuloInstanceID;
    private String fluoApplicationID;
    private FluoConfiguration config;
    private SharedResources resources;
    private MetricNames metricNames;
    private SimpleConfiguration appConfig;
    private String metricsReporterID;

    public Environment(FluoConfiguration configuration) {
        this.config = configuration;
        this.conn = AccumuloUtil.getConnector(this.config);
        this.readZookeeperConfig();
        if (!this.conn.getInstance().getInstanceName().equals(this.accumuloInstance)) {
            throw new IllegalArgumentException("unexpected accumulo instance name " + this.conn.getInstance().getInstanceName() + " != " + this.accumuloInstance);
        }
        if (!this.conn.getInstance().getInstanceID().equals(this.accumuloInstanceID)) {
            throw new IllegalArgumentException("unexpected accumulo instance id " + this.conn.getInstance().getInstanceID() + " != " + this.accumuloInstanceID);
        }
        try {
            this.resources = new SharedResources(this);
        }
        catch (TableNotFoundException e1) {
            throw new IllegalStateException(e1);
        }
    }

    @VisibleForTesting
    public Environment(Environment env) throws Exception {
        this.table = env.table;
        this.auths = env.auths;
        this.accumuloInstance = env.accumuloInstance;
        this.observers = env.observers;
        this.weakObservers = env.weakObservers;
        this.allObserversColumns = env.allObserversColumns;
        this.conn = env.conn;
        this.accumuloInstanceID = env.accumuloInstanceID;
        this.fluoApplicationID = env.fluoApplicationID;
        this.config = env.config;
        this.resources = new SharedResources(this);
    }

    private void readZookeeperConfig() {
        try (CuratorFramework curator = CuratorUtil.newAppCurator(this.config);){
            curator.start();
            this.accumuloInstance = new String((byte[])curator.getData().forPath("/config/accumulo.instance.name"), StandardCharsets.UTF_8);
            this.accumuloInstanceID = new String((byte[])curator.getData().forPath("/config/accumulo.instance.id"), StandardCharsets.UTF_8);
            this.fluoApplicationID = new String((byte[])curator.getData().forPath("/config/fluo.application.id"), StandardCharsets.UTF_8);
            this.table = new String((byte[])curator.getData().forPath("/config/accumulo.table"), StandardCharsets.UTF_8);
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])curator.getData().forPath("/config/fluo.observers"));
            DataInputStream dis = new DataInputStream(bais);
            this.observers = Collections.unmodifiableMap(Environment.readObservers(dis));
            this.weakObservers = Collections.unmodifiableMap(Environment.readObservers(dis));
            this.allObserversColumns = new HashSet<Column>();
            this.allObserversColumns.addAll(this.observers.keySet());
            this.allObserversColumns.addAll(this.weakObservers.keySet());
            this.allObserversColumns = Collections.unmodifiableSet(this.allObserversColumns);
            bais = new ByteArrayInputStream((byte[])curator.getData().forPath("/config/shared.config"));
            Properties sharedProps = new Properties();
            sharedProps.load(bais);
            FluoConfiguration tmpConfig = new FluoConfiguration();
            for (String prop : sharedProps.stringPropertyNames()) {
                this.config.setProperty(prop, sharedProps.getProperty(prop));
                tmpConfig.setProperty(prop, sharedProps.getProperty(prop));
            }
            this.appConfig = tmpConfig.getAppConfiguration();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<Column, ObserverSpecification> readObservers(DataInputStream dis) throws IOException {
        HashMap<Column, ObserverSpecification> omap = new HashMap<Column, ObserverSpecification>();
        int num = WritableUtils.readVInt((DataInput)dis);
        for (int i = 0; i < num; ++i) {
            Column col = ColumnUtil.readColumn(dis);
            String clazz = dis.readUTF();
            HashMap<String, String> params = new HashMap<String, String>();
            int numParams = WritableUtils.readVInt((DataInput)dis);
            for (int j = 0; j < numParams; ++j) {
                String k = dis.readUTF();
                String v = dis.readUTF();
                params.put(k, v);
            }
            ObserverSpecification ospec = new ObserverSpecification(clazz, params);
            omap.put(col, ospec);
        }
        return omap;
    }

    public void setAuthorizations(Authorizations auths) {
        this.auths = auths;
        this.resources.close();
        try {
            this.resources = new SharedResources(this);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public Authorizations getAuthorizations() {
        return this.auths;
    }

    public String getAccumuloInstance() {
        return this.accumuloInstance;
    }

    public String getAccumuloInstanceID() {
        return this.accumuloInstanceID;
    }

    public String getFluoApplicationID() {
        return this.fluoApplicationID;
    }

    public Map<Column, ObserverSpecification> getObservers() {
        return this.observers;
    }

    public Map<Column, ObserverSpecification> getWeakObservers() {
        return this.weakObservers;
    }

    public String getTable() {
        return this.table;
    }

    public Connector getConnector() {
        return this.conn;
    }

    public SharedResources getSharedResources() {
        return this.resources;
    }

    public FluoConfiguration getConfiguration() {
        return this.config;
    }

    public synchronized String getMetricsReporterID() {
        if (this.metricsReporterID == null) {
            String mid = System.getProperty("fluo.metrics.reporter.id");
            if (mid == null) {
                try {
                    String hostname = InetAddress.getLocalHost().getHostName();
                    int idx = hostname.indexOf(46);
                    if (idx > 0) {
                        hostname = hostname.substring(0, idx);
                    }
                    mid = hostname + "_" + this.getSharedResources().getTransactorID();
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            }
            this.metricsReporterID = mid.replace('.', '_');
        }
        return this.metricsReporterID;
    }

    public String getMetricsAppName() {
        return this.config.getApplicationName().replace('.', '_');
    }

    public synchronized MetricNames getMetricNames() {
        if (this.metricNames == null) {
            this.metricNames = new MetricNames(this.getMetricsReporterID(), this.getMetricsAppName());
        }
        return this.metricNames;
    }

    public MetricsReporter getMetricsReporter() {
        return new MetricsReporterImpl(this.getConfiguration(), this.getSharedResources().getMetricRegistry(), this.getMetricsReporterID());
    }

    public SimpleConfiguration getAppConfiguration() {
        return new SimpleConfiguration(this.appConfig);
    }

    @Override
    public void close() {
        this.resources.close();
    }
}

