/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.curator.framework.CuratorFramework;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.core.util.ColumnUtil;
import org.apache.fluo.core.util.CuratorUtil;
import org.apache.hadoop.io.WritableUtils;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operations {
    private static final Logger logger = LoggerFactory.getLogger(Operations.class);

    private Operations() {
    }

    public static void updateSharedConfig(CuratorFramework curator, Properties sharedProps) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        sharedProps.store(baos, "Shared java props");
        CuratorUtil.putData(curator, "/config/shared.config", baos.toByteArray(), CuratorUtil.NodeExistsPolicy.OVERWRITE);
    }

    public static void updateObservers(CuratorFramework curator, Map<Column, ObserverSpecification> colObservers, Map<Column, ObserverSpecification> weakObservers) throws Exception {
        String observerPath = "/config/fluo.observers";
        try {
            curator.delete().deletingChildrenIfNeeded().forPath(observerPath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            logger.error("An error occurred deleting Zookeeper node. node=[" + observerPath + "], error=[" + e.getMessage() + "]");
            throw new RuntimeException(e);
        }
        byte[] serializedObservers = Operations.serializeObservers(colObservers, weakObservers);
        CuratorUtil.putData(curator, observerPath, serializedObservers, CuratorUtil.NodeExistsPolicy.OVERWRITE);
    }

    private static void serializeObservers(DataOutputStream dos, Map<Column, ObserverSpecification> colObservers) throws IOException {
        Set<Map.Entry<Column, ObserverSpecification>> es = colObservers.entrySet();
        WritableUtils.writeVInt((DataOutput)dos, (int)colObservers.size());
        for (Map.Entry<Column, ObserverSpecification> entry : es) {
            ColumnUtil.writeColumn(entry.getKey(), dos);
            dos.writeUTF(entry.getValue().getClassName());
            Map params = entry.getValue().getConfiguration().toMap();
            WritableUtils.writeVInt((DataOutput)dos, (int)params.size());
            for (Map.Entry pentry : params.entrySet()) {
                dos.writeUTF((String)pentry.getKey());
                dos.writeUTF((String)pentry.getValue());
            }
        }
    }

    private static byte[] serializeObservers(Map<Column, ObserverSpecification> colObservers, Map<Column, ObserverSpecification> weakObservers) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputStream dos = new DataOutputStream(baos);){
            Operations.serializeObservers(dos, colObservers);
            Operations.serializeObservers(dos, weakObservers);
        }
        byte[] serializedObservers = baos.toByteArray();
        return serializedObservers;
    }
}

