/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.fluo.api.client.FluoClient;
import org.apache.fluo.api.client.LoaderExecutor;
import org.apache.fluo.api.client.Snapshot;
import org.apache.fluo.api.client.Transaction;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.metrics.MetricsReporter;
import org.apache.fluo.core.client.LoaderExecutorAsyncImpl;
import org.apache.fluo.core.impl.Environment;
import org.apache.fluo.core.impl.TransactionImpl;
import org.apache.fluo.core.log.TracingTransaction;
import org.apache.fluo.core.metrics.ReporterUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoClientImpl
implements FluoClient {
    private static final Logger log = LoggerFactory.getLogger(FluoClientImpl.class);
    private static final AtomicInteger reporterCounter = new AtomicInteger(1);
    private FluoConfiguration config;
    private Environment env;
    private AutoCloseable reporter;

    public static final AutoCloseable setupReporters(Environment env, String id, AtomicInteger reporterCounter) {
        return ReporterUtil.setupReporters(env, "fluo." + id + "." + reporterCounter.getAndIncrement());
    }

    public FluoClientImpl(FluoConfiguration config) {
        this.config = config;
        if (!config.hasRequiredClientProps()) {
            String msg = "Client configuration is missing required properties";
            log.error(msg);
            throw new IllegalArgumentException(msg);
        }
        try {
            this.env = new Environment(config);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.reporter = FluoClientImpl.setupReporters(this.env, "client", reporterCounter);
    }

    public LoaderExecutor newLoaderExecutor() {
        try {
            return new LoaderExecutorAsyncImpl(this.config, this.env);
        }
        catch (Exception e) {
            log.error("Failed to create a LoaderExecutor");
            throw new IllegalStateException(e);
        }
    }

    public Snapshot newSnapshot() {
        TransactionImpl tx = new TransactionImpl(this.env);
        if (TracingTransaction.isTracingEnabled()) {
            return new TracingTransaction(tx);
        }
        return tx;
    }

    public Transaction newTransaction() {
        TransactionImpl tx = new TransactionImpl(this.env){

            @Override
            public void commit() {
                super.commit();
                FluoClientImpl.this.env.getSharedResources().getBatchWriter().waitForAsyncFlush();
            }
        };
        if (TracingTransaction.isTracingEnabled()) {
            return new TracingTransaction(tx);
        }
        return tx;
    }

    public SimpleConfiguration getAppConfiguration() {
        return this.env.getAppConfiguration();
    }

    public MetricsReporter getMetricsReporter() {
        return this.env.getMetricsReporter();
    }

    public void close() {
        this.env.close();
        try {
            this.reporter.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

