/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.client;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.curator.framework.CuratorFramework;
import org.apache.fluo.accumulo.iterators.GarbageCollectionIterator;
import org.apache.fluo.accumulo.iterators.NotificationIterator;
import org.apache.fluo.accumulo.util.ColumnConstants;
import org.apache.fluo.accumulo.util.ZookeeperUtil;
import org.apache.fluo.api.client.FluoAdmin;
import org.apache.fluo.api.config.FluoConfiguration;
import org.apache.fluo.api.config.ObserverSpecification;
import org.apache.fluo.api.config.SimpleConfiguration;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.exceptions.FluoException;
import org.apache.fluo.api.observer.Observer;
import org.apache.fluo.core.client.Operations;
import org.apache.fluo.core.util.AccumuloUtil;
import org.apache.fluo.core.util.ByteUtil;
import org.apache.fluo.core.util.CuratorUtil;
import org.apache.fluo.core.worker.ObserverContext;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluoAdminImpl
implements FluoAdmin {
    private static Logger logger = LoggerFactory.getLogger(FluoAdminImpl.class);
    private final FluoConfiguration config;
    private final CuratorFramework rootCurator;
    private CuratorFramework appCurator = null;
    private final String appRootDir;

    public FluoAdminImpl(FluoConfiguration config) {
        this.config = config;
        if (!config.hasRequiredAdminProps()) {
            throw new IllegalArgumentException("Admin configuration is missing required properties");
        }
        this.appRootDir = ZookeeperUtil.parseRoot((String)config.getAppZookeepers());
        this.rootCurator = CuratorUtil.newRootFluoCurator(config);
        this.rootCurator.start();
    }

    private synchronized CuratorFramework getAppCurator() {
        if (this.appCurator == null) {
            this.appCurator = CuratorUtil.newAppCurator(this.config);
            this.appCurator.start();
        }
        return this.appCurator;
    }

    public void initialize(FluoAdmin.InitializationOptions opts) throws FluoAdmin.AlreadyInitializedException, FluoAdmin.TableExistsException {
        Preconditions.checkArgument((!ZookeeperUtil.parseRoot((String)this.config.getInstanceZookeepers()).equals("/") ? 1 : 0) != 0, (Object)"The Zookeeper connection string (set by 'fluo.client.zookeeper.connect')  must have a chroot suffix.");
        if (this.zookeeperInitialized() && !opts.getClearZookeeper()) {
            throw new FluoAdmin.AlreadyInitializedException("Fluo application already initialized at " + this.config.getAppZookeepers());
        }
        Connector conn = AccumuloUtil.getConnector(this.config);
        boolean tableExists = conn.tableOperations().exists(this.config.getAccumuloTable());
        if (tableExists && !opts.getClearTable()) {
            throw new FluoAdmin.TableExistsException("Accumulo table already exists " + this.config.getAccumuloTable());
        }
        if (tableExists) {
            logger.info("The Accumulo table '{}' will be dropped and created as requested by user", (Object)this.config.getAccumuloTable());
            try {
                conn.tableOperations().delete(this.config.getAccumuloTable());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (this.rootCurator.checkExists().forPath(this.appRootDir) != null) {
                logger.info("Clearing Fluo '{}' application in Zookeeper at {}", (Object)this.config.getApplicationName(), (Object)this.config.getAppZookeepers());
                this.rootCurator.delete().deletingChildrenIfNeeded().forPath(this.appRootDir);
            }
        }
        catch (KeeperException.NoNodeException e) {
        }
        catch (Exception e) {
            logger.error("An error occurred deleting Zookeeper root of [" + this.config.getAppZookeepers() + "], error=[" + e.getMessage() + "]");
            throw new RuntimeException(e);
        }
        try {
            this.initialize(conn);
            this.updateSharedConfig();
            if (!this.config.getAccumuloClasspath().trim().isEmpty()) {
                String contextName = "fluo";
                conn.instanceOperations().setProperty("general.vfs.context.classpath.fluo", this.config.getAccumuloClasspath());
                conn.tableOperations().setProperty(this.config.getAccumuloTable(), "table.classpath.context", contextName);
            }
            conn.tableOperations().setProperty(this.config.getAccumuloTable(), "table.cache.block.enable", "true");
        }
        catch (KeeperException.NodeExistsException nee) {
            throw new FluoAdmin.AlreadyInitializedException();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private void initialize(Connector conn) throws Exception {
        String accumuloInstanceName = conn.getInstance().getInstanceName();
        String accumuloInstanceID = conn.getInstance().getInstanceID();
        String fluoApplicationID = UUID.randomUUID().toString();
        CuratorUtil.putData(this.rootCurator, this.appRootDir, new byte[0], CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorFramework curator = this.getAppCurator();
        CuratorUtil.putData(curator, "/config", new byte[0], CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/config/accumulo.table", this.config.getAccumuloTable().getBytes(StandardCharsets.UTF_8), CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/config/accumulo.instance.name", accumuloInstanceName.getBytes(StandardCharsets.UTF_8), CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/config/accumulo.instance.id", accumuloInstanceID.getBytes(StandardCharsets.UTF_8), CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/config/fluo.application.id", fluoApplicationID.getBytes(StandardCharsets.UTF_8), CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/oracle/server", new byte[0], CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/oracle/max-timestamp", new byte[]{50}, CuratorUtil.NodeExistsPolicy.FAIL);
        CuratorUtil.putData(curator, "/oracle/gc-timestamp", new byte[]{48}, CuratorUtil.NodeExistsPolicy.FAIL);
        conn.tableOperations().create(this.config.getAccumuloTable(), false);
        HashMap<String, Set<Text>> groups = new HashMap<String, Set<Text>>();
        groups.put("notify", Collections.singleton(ByteUtil.toText(ColumnConstants.NOTIFY_CF)));
        conn.tableOperations().setLocalityGroups(this.config.getAccumuloTable(), groups);
        IteratorSetting gcIter = new IteratorSetting(10, "gc", GarbageCollectionIterator.class);
        GarbageCollectionIterator.setZookeepers((IteratorSetting)gcIter, (String)this.config.getAppZookeepers());
        conn.tableOperations().attachIterator(this.config.getAccumuloTable(), gcIter, EnumSet.of(IteratorUtil.IteratorScope.majc, IteratorUtil.IteratorScope.minc));
        IteratorSetting ntfyIter = new IteratorSetting(11, "ntfy", NotificationIterator.class);
        conn.tableOperations().attachIterator(this.config.getAccumuloTable(), ntfyIter, EnumSet.of(IteratorUtil.IteratorScope.majc, IteratorUtil.IteratorScope.minc));
    }

    public void updateSharedConfig() {
        logger.info("Setting up observers using app config: {}", (Object)this.config.getAppConfiguration());
        HashMap<Column, ObserverSpecification> colObservers = new HashMap<Column, ObserverSpecification>();
        HashMap<Column, ObserverSpecification> weakObservers = new HashMap<Column, ObserverSpecification>();
        for (ObserverSpecification ospec : this.config.getObserverSpecifications()) {
            Observer observer;
            try {
                observer = Class.forName(ospec.getClassName()).asSubclass(Observer.class).newInstance();
            }
            catch (ClassNotFoundException e1) {
                throw new FluoException("Observer class '" + ospec.getClassName() + "' was not found.  Check for class name misspellings or failure to include the observer jar.", (Throwable)e1);
            }
            catch (IllegalAccessException | InstantiationException e2) {
                throw new FluoException("Observer class '" + ospec.getClassName() + "' could not be created.", (Throwable)e2);
            }
            SimpleConfiguration oc = ospec.getConfiguration();
            logger.info("Setting up observer {} using params {}.", (Object)observer.getClass().getSimpleName(), (Object)oc.toMap());
            try {
                observer.init((Observer.Context)new ObserverContext(this.config.subset("fluo.app"), oc));
            }
            catch (Exception e) {
                throw new FluoException("Observer '" + ospec.getClassName() + "' could not be initialized", (Throwable)e);
            }
            Observer.ObservedColumn observedCol = observer.getObservedColumn();
            if (observedCol.getType() == Observer.NotificationType.STRONG) {
                colObservers.put(observedCol.getColumn(), ospec);
                continue;
            }
            weakObservers.put(observedCol.getColumn(), ospec);
        }
        Properties sharedProps = new Properties();
        Iterator iter = this.config.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (key.equals("fluo.tx.rollback.time")) {
                sharedProps.setProperty(key, Long.toString(this.config.getLong(key)));
                continue;
            }
            if (!key.startsWith("fluo.app")) continue;
            sharedProps.setProperty(key, this.config.getRawString(key));
        }
        try {
            CuratorFramework curator = this.getAppCurator();
            Operations.updateObservers(curator, colObservers, weakObservers);
            Operations.updateSharedConfig(curator, sharedProps);
        }
        catch (Exception e) {
            throw new FluoException("Failed to update shared configuration in Zookeeper", (Throwable)e);
        }
    }

    public void close() {
        this.rootCurator.close();
        if (this.appCurator != null) {
            this.appCurator.close();
        }
    }

    public boolean oracleExists() {
        CuratorFramework curator = this.getAppCurator();
        try {
            return curator.checkExists().forPath("/oracle/server") != null && !((List)curator.getChildren().forPath("/oracle/server")).isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean zookeeperInitialized() {
        try {
            return this.rootCurator.checkExists().forPath(this.appRootDir) != null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean accumuloTableExists() {
        Connector conn = AccumuloUtil.getConnector(this.config);
        return conn.tableOperations().exists(this.config.getAccumuloTable());
    }
}

