/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.core.async;

import java.util.concurrent.CountDownLatch;
import org.apache.fluo.api.exceptions.CommitException;
import org.apache.fluo.api.exceptions.FluoException;
import org.apache.fluo.core.async.AsyncCommitObserver;
import org.apache.fluo.core.exceptions.AlreadyAcknowledgedException;

public class SyncCommitObserver
implements AsyncCommitObserver {
    private CountDownLatch cdl = new CountDownLatch(1);
    private volatile boolean committed = false;
    private volatile boolean aacked = false;
    private volatile Exception error = null;

    @Override
    public void committed() {
        this.committed = Boolean.TRUE;
        this.cdl.countDown();
    }

    @Override
    public void failed(Throwable t) {
        this.error = (Exception)t;
        this.cdl.countDown();
    }

    @Override
    public void alreadyAcknowledged() {
        this.aacked = true;
        this.cdl.countDown();
    }

    @Override
    public void commitFailed() {
        this.committed = false;
        this.cdl.countDown();
    }

    public void waitForCommit() {
        try {
            this.cdl.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.error != null) {
            throw new FluoException((Throwable)this.error);
        }
        if (this.aacked) {
            throw new AlreadyAcknowledgedException();
        }
        if (!this.committed) {
            throw new CommitException();
        }
    }
}

