/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.api.client;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.fluo.api.client.SnapshotBase;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;
import org.apache.fluo.api.data.RowColumn;

public abstract class AbstractSnapshotBase
implements SnapshotBase {
    @Override
    public Bytes get(Bytes row, Column column, Bytes defaultValue) {
        Bytes ret = this.get(row, column);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public Map<Column, Bytes> get(Bytes row, Column ... columns) {
        return this.get(row, (Set<Column>)ImmutableSet.copyOf((Object[])columns));
    }

    @Override
    public Map<Bytes, Map<Column, Bytes>> get(Collection<Bytes> rows, Column ... columns) {
        return this.get(rows, (Set<Column>)ImmutableSet.copyOf((Object[])columns));
    }

    @Override
    public Map<RowColumn, String> gets(Collection<RowColumn> rowColumns) {
        Map<RowColumn, Bytes> bytesMap = this.get(rowColumns);
        return Maps.transformValues(bytesMap, b -> b.toString());
    }

    @Override
    public Map<String, Map<Column, String>> gets(Collection<? extends CharSequence> rows, Set<Column> columns) {
        Map<Bytes, Map<Column, Bytes>> rcvs = this.get((Collection<Bytes>)Collections2.transform(rows, s -> Bytes.of(s)), columns);
        HashMap<String, Map<Column, String>> ret = new HashMap<String, Map<Column, String>>(rcvs.size());
        for (Map.Entry<Bytes, Map<Column, Bytes>> entry : rcvs.entrySet()) {
            ret.put(entry.getKey().toString(), Maps.transformValues(entry.getValue(), b -> b.toString()));
        }
        return ret;
    }

    @Override
    public Map<String, Map<Column, String>> gets(Collection<? extends CharSequence> rows, Column ... columns) {
        return this.gets(rows, (Set<Column>)ImmutableSet.copyOf((Object[])columns));
    }

    @Override
    public String gets(CharSequence row, Column column) {
        Bytes val = this.get(Bytes.of(row), column);
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    @Override
    public String gets(CharSequence row, Column column, String defaultValue) {
        Bytes val = this.get(Bytes.of(row), column);
        if (val == null) {
            return defaultValue;
        }
        return val.toString();
    }

    @Override
    public Map<Column, String> gets(CharSequence row, Set<Column> columns) {
        Map<Column, Bytes> values = this.get(Bytes.of(row), columns);
        return Maps.transformValues(values, b -> b.toString());
    }

    @Override
    public Map<Column, String> gets(CharSequence row, Column ... columns) {
        return this.gets(row, (Set<Column>)ImmutableSet.copyOf((Object[])columns));
    }
}

