/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.values;

import java.util.List;
import org.apache.fluo.accumulo.format.FluoFormatter;
import org.apache.fluo.accumulo.util.ByteArrayUtil;
import org.apache.fluo.accumulo.util.LongUtil;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;

public class LockValue {
    private final Bytes prow;
    private final Column pcol;
    private final boolean isWrite;
    private final boolean isDelete;
    private final boolean isTrigger;
    private final Long transactor;

    public LockValue(byte[] enc) {
        List<Bytes> fields = ByteArrayUtil.split(enc);
        if (fields.size() != 6) {
            throw new IllegalArgumentException("more fields than expected");
        }
        this.prow = fields.get(0);
        this.pcol = new Column(fields.get(1), fields.get(2), fields.get(3));
        this.isWrite = (fields.get(4).byteAt(0) & 1) == 1;
        this.isDelete = (fields.get(4).byteAt(0) & 2) == 2;
        this.isTrigger = (fields.get(4).byteAt(0) & 4) == 4;
        this.transactor = ByteArrayUtil.decodeLong(fields.get(5).toArray());
    }

    public Bytes getPrimaryRow() {
        return this.prow;
    }

    public Column getPrimaryColumn() {
        return this.pcol;
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public boolean isTrigger() {
        return this.isTrigger;
    }

    public Long getTransactor() {
        return this.transactor;
    }

    public static byte[] encode(Bytes prow, Column pcol, boolean isWrite, boolean isDelete, boolean isTrigger, Long transactor) {
        byte[] bools = new byte[]{0};
        if (isWrite) {
            bools[0] = 1;
        }
        if (isDelete) {
            bools[0] = (byte)(bools[0] | 2);
        }
        if (isTrigger) {
            bools[0] = (byte)(bools[0] | 4);
        }
        return ByteArrayUtil.concat(prow, pcol.getFamily(), pcol.getQualifier(), pcol.getVisibility(), Bytes.of((byte[])bools), Bytes.of((byte[])ByteArrayUtil.encode(transactor)));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        FluoFormatter.encNonAscii(sb, this.prow);
        sb.append(" ");
        FluoFormatter.encNonAscii(sb, this.pcol.getFamily());
        sb.append(" ");
        FluoFormatter.encNonAscii(sb, this.pcol.getQualifier());
        sb.append(" ");
        FluoFormatter.encNonAscii(sb, this.pcol.getVisibility());
        sb.append(" ");
        sb.append(this.isWrite ? "WRITE" : "NOT_WRITE");
        sb.append(" ");
        sb.append(this.isDelete ? "DELETE" : "NOT_DELETE");
        sb.append(" ");
        sb.append(this.isTrigger ? "TRIGGER" : "NOT_TRIGGER");
        sb.append(" ");
        sb.append(LongUtil.toMaxRadixString(this.transactor));
        return sb.toString();
    }
}

