/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.util;

import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.fluo.accumulo.util.LongUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperUtil {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperUtil.class);
    public static final long OLDEST_POSSIBLE = -1L;

    private ZookeeperUtil() {
    }

    public static String parseServers(String zookeepers) {
        int slashIndex = zookeepers.indexOf("/");
        if (slashIndex != -1) {
            return zookeepers.substring(0, slashIndex);
        }
        return zookeepers;
    }

    public static String parseRoot(String zookeepers) {
        int slashIndex = zookeepers.indexOf("/");
        if (slashIndex != -1) {
            return zookeepers.substring(slashIndex).trim();
        }
        return "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getGcTimestamp(String zookeepers) {
        ZooKeeper zk = null;
        try {
            zk = new ZooKeeper(zookeepers, 30000, null);
            long start = System.currentTimeMillis();
            while (!zk.getState().isConnected() && System.currentTimeMillis() - start < 30000L) {
                Uninterruptibles.sleepUninterruptibly((long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            byte[] d = zk.getData("/oracle/gc-timestamp", false, null);
            long l = LongUtil.fromByteArray(d);
            return l;
        }
        catch (IOException | InterruptedException | KeeperException e) {
            log.warn("Failed to get oldest timestamp of Oracle from Zookeeper", e);
            long l = -1L;
            return l;
        }
        finally {
            if (zk != null) {
                try {
                    zk.close();
                }
                catch (InterruptedException e) {
                    log.error("Failed to close zookeeper client", (Throwable)e);
                }
            }
        }
    }
}

