/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.fluo.api.data.Bytes;
import org.apache.hadoop.io.WritableUtils;

public class ByteArrayUtil {
    private ByteArrayUtil() {
    }

    public static byte[] encode(long v) {
        byte[] ba = new byte[8];
        ByteArrayUtil.encode(ba, 0, v);
        return ba;
    }

    public static byte[] encode(byte[] ba, int offset, long v) {
        ba[offset + 0] = (byte)(v >>> 56);
        ba[offset + 1] = (byte)(v >>> 48);
        ba[offset + 2] = (byte)(v >>> 40);
        ba[offset + 3] = (byte)(v >>> 32);
        ba[offset + 4] = (byte)(v >>> 24);
        ba[offset + 5] = (byte)(v >>> 16);
        ba[offset + 6] = (byte)(v >>> 8);
        ba[offset + 7] = (byte)(v >>> 0);
        return ba;
    }

    public static long decodeLong(byte[] ba, int offset) {
        return ((long)ba[offset + 0] << 56) + ((long)(ba[offset + 1] & 0xFF) << 48) + ((long)(ba[offset + 2] & 0xFF) << 40) + ((long)(ba[offset + 3] & 0xFF) << 32) + ((long)(ba[offset + 4] & 0xFF) << 24) + (long)((ba[offset + 5] & 0xFF) << 16) + (long)((ba[offset + 6] & 0xFF) << 8) + (long)((ba[offset + 7] & 0xFF) << 0);
    }

    public static long decodeLong(byte[] ba) {
        return ByteArrayUtil.decodeLong(ba, 0);
    }

    public static final byte[] concat(Bytes ... listOfBytes) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            for (Bytes b : listOfBytes) {
                WritableUtils.writeVInt((DataOutput)dos, (int)b.length());
                b.writeTo((OutputStream)dos);
            }
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static final List<Bytes> split(byte[] b) {
        ArrayList<Bytes> ret = new ArrayList<Bytes>();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(b);
            Throwable throwable = null;
            try {
                try {
                    DataInputStream dis = new DataInputStream(in);
                    Bytes.BytesBuilder builder = Bytes.builder((int)b.length);
                    while (true) {
                        int len = WritableUtils.readVInt((DataInput)dis);
                        builder.append((InputStream)dis, len);
                        ret.add(builder.toBytes());
                        builder.setLength(0);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (in != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStream)in).close();
                    }
                }
                throw throwable3;
            }
        }
        catch (EOFException in) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ret;
    }
}

