/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ArrayByteSequence;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.fluo.accumulo.iterators.TimestampSkippingIterator;
import org.apache.fluo.accumulo.util.ColumnConstants;
import org.apache.fluo.accumulo.values.WriteValue;

public class SnapshotIterator
implements SortedKeyValueIterator<Key, Value> {
    @VisibleForTesting
    static final String TIMESTAMP_OPT = "timestampOpt";
    private static final ByteSequence NOTIFY_CF_BS = new ArrayByteSequence(ColumnConstants.NOTIFY_CF.toArray());
    static final Set<ByteSequence> NOTIFY_CF_SET = Collections.singleton(NOTIFY_CF_BS);
    private TimestampSkippingIterator source;
    private long snaptime;
    private boolean hasTop = false;
    private final Key curCol = new Key();

    private void findTop() throws IOException {
        block0: while (this.source.hasTop()) {
            long invalidationTime = -1L;
            long dataPointer = -1L;
            if (this.source.getTopKey().getColumnFamilyData().equals((Object)NOTIFY_CF_BS)) {
                throw new IllegalStateException("seeing notifications during snapshot iteration");
            }
            this.curCol.set(this.source.getTopKey());
            while (this.source.hasTop() && this.curCol.equals(this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
                long colType = this.source.getTopKey().getTimestamp() & 0xE000000000000000L;
                long ts = this.source.getTopKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
                if (colType == 0x6000000000000000L) {
                    this.source.skipToPrefix(this.curCol, 0x4000000000000000L);
                    continue;
                }
                if (colType == 0x4000000000000000L) {
                    long timePtr = WriteValue.getTimestamp(this.source.getTopValue().get());
                    if (timePtr > invalidationTime) {
                        invalidationTime = timePtr;
                    }
                    if (dataPointer == -1L) {
                        if (ts <= this.snaptime) {
                            dataPointer = timePtr;
                            this.source.skipToPrefix(this.curCol, 0x2000000000000000L);
                            continue;
                        }
                        this.source.skipToTimestamp(this.curCol, 0x4000000000000000L | this.snaptime);
                        continue;
                    }
                } else {
                    if (colType == 0x2000000000000000L) {
                        if (ts > invalidationTime) {
                            invalidationTime = ts;
                        }
                        this.source.skipToPrefix(this.curCol, -2305843009213693952L);
                        continue;
                    }
                    if (colType == -2305843009213693952L) {
                        if (ts > invalidationTime && ts <= this.snaptime) {
                            return;
                        }
                        if (dataPointer == -1L) {
                            this.source.skipColumn(this.curCol);
                            continue block0;
                        }
                        this.source.skipToTimestamp(this.curCol, 0xA000000000000000L | dataPointer);
                        continue;
                    }
                    if (colType == -6917529027641081856L) {
                        if (dataPointer == ts) {
                            return;
                        }
                        if (ts < dataPointer || dataPointer == -1L) {
                            this.source.skipColumn(this.curCol);
                            continue block0;
                        }
                        if (ts > dataPointer) {
                            this.source.skipToTimestamp(this.curCol, 0xA000000000000000L | dataPointer);
                            continue;
                        }
                    } else {
                        if (colType == -4611686018427387904L) {
                            if (dataPointer == -1L) {
                                this.source.skipColumn(this.curCol);
                                continue block0;
                            }
                            this.source.skipToTimestamp(this.curCol, 0xA000000000000000L | dataPointer);
                            continue;
                        }
                        throw new IllegalArgumentException();
                    }
                }
                this.source.next();
            }
        }
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = new TimestampSkippingIterator(source);
        this.snaptime = Long.parseLong(options.get(TIMESTAMP_OPT));
    }

    public boolean hasTop() {
        return this.hasTop && this.source.hasTop();
    }

    public void next() throws IOException {
        this.curCol.set(this.source.getTopKey());
        this.source.skipColumn(this.curCol);
        this.findTop();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        boolean inc;
        Collection<ByteSequence> cols;
        Range newRange = range;
        this.hasTop = true;
        if (range.getStartKey() != null && range.getStartKey().getTimestamp() != Long.MAX_VALUE && !range.isStartKeyInclusive()) {
            Key nextCol = range.getStartKey().followingKey(PartialKey.ROW_COLFAM_COLQUAL_COLVIS);
            if (range.afterEndKey(nextCol)) {
                this.hasTop = false;
                return;
            }
            newRange = new Range(nextCol, true, range.getEndKey(), range.isEndKeyInclusive());
        } else {
            newRange = range;
        }
        if (columnFamilies.size() == 0 && !inclusive) {
            cols = NOTIFY_CF_SET;
            inc = false;
        } else {
            cols = columnFamilies;
            inc = inclusive;
        }
        this.source.seek(newRange, cols, inc);
        this.findTop();
    }

    public Key getTopKey() {
        return this.source.getTopKey();
    }

    public Value getTopValue() {
        return this.source.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public static void setSnaptime(IteratorSetting cfg, long time) {
        if (time < 0L || (0xE000000000000000L & time) != 0L) {
            throw new IllegalArgumentException();
        }
        cfg.addOption(TIMESTAMP_OPT, time + "");
    }
}

