/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class PushbackIterator
implements SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> source;
    private Key pushedKey = null;
    private Value pushedValue = null;

    public PushbackIterator(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean hasTop() {
        return this.pushedKey != null || this.source.hasTop();
    }

    public void next() throws IOException {
        if (this.pushedKey != null) {
            this.pushedKey = null;
            this.pushedValue = null;
        } else {
            this.source.next();
        }
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.pushedKey = null;
        this.pushedValue = null;
        this.source.seek(range, columnFamilies, inclusive);
    }

    public Key getTopKey() {
        if (this.pushedKey != null) {
            return this.pushedKey;
        }
        return (Key)this.source.getTopKey();
    }

    public Value getTopValue() {
        if (this.pushedKey != null) {
            return this.pushedValue;
        }
        return (Value)this.source.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }

    public void pushback(Key key, Value val) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(val);
        Preconditions.checkState((this.pushedKey == null ? 1 : 0) != 0);
        Preconditions.checkState((this.pushedValue == null ? 1 : 0) != 0);
        if (this.source.hasTop()) {
            Preconditions.checkArgument((((Key)this.source.getTopKey()).compareTo(key) >= 0 ? 1 : 0) != 0);
        }
        this.pushedKey = key;
        this.pushedValue = val;
    }
}

