/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.iterators;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.fluo.accumulo.iterators.SnapshotIterator;
import org.apache.fluo.accumulo.iterators.TimestampSkippingIterator;
import org.apache.fluo.accumulo.values.WriteValue;

public class PrewriteIterator
implements SortedKeyValueIterator<Key, Value> {
    private static final String TIMESTAMP_OPT = "timestampOpt";
    private static final String CHECK_ACK_OPT = "checkAckOpt";
    private static final String NTFY_TIMESTAMP_OPT = "ntfyTsOpt";
    private TimestampSkippingIterator source;
    private long snaptime;
    boolean hasTop = false;
    boolean checkAck = false;
    long ntfyTimestamp = -1L;

    public static void setSnaptime(IteratorSetting cfg, long time) {
        if (time < 0L || (0xE000000000000000L & time) != 0L) {
            throw new IllegalArgumentException();
        }
        cfg.addOption(TIMESTAMP_OPT, time + "");
    }

    public static void enableAckCheck(IteratorSetting cfg, long timestamp) {
        cfg.addOption(CHECK_ACK_OPT, "true");
        cfg.addOption(NTFY_TIMESTAMP_OPT, timestamp + "");
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = new TimestampSkippingIterator(source);
        this.snaptime = Long.parseLong(options.get(TIMESTAMP_OPT));
        if (options.containsKey(CHECK_ACK_OPT)) {
            this.checkAck = Boolean.parseBoolean(options.get(CHECK_ACK_OPT));
            this.ntfyTimestamp = Long.parseLong(options.get(NTFY_TIMESTAMP_OPT));
        }
    }

    public boolean hasTop() {
        return this.hasTop && this.source.hasTop();
    }

    public void next() throws IOException {
        this.hasTop = false;
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        Collection<ByteSequence> fams;
        if (columnFamilies.isEmpty() && !inclusive) {
            fams = SnapshotIterator.NOTIFY_CF_SET;
            inclusive = false;
        } else {
            fams = columnFamilies;
        }
        Key endKey = new Key(range.getStartKey());
        if (this.checkAck) {
            endKey.setTimestamp(-4611686018427387905L);
        } else {
            endKey.setTimestamp(-2305843009213693953L);
        }
        Range seekRange = new Range(range.getStartKey(), true, endKey, false);
        this.source.seek(seekRange, fams, inclusive);
        this.hasTop = false;
        long invalidationTime = -1L;
        while (this.source.hasTop() && seekRange.getStartKey().equals(this.source.getTopKey(), PartialKey.ROW_COLFAM_COLQUAL_COLVIS)) {
            long colType = this.source.getTopKey().getTimestamp() & 0xE000000000000000L;
            long ts = this.source.getTopKey().getTimestamp() & 0x1FFFFFFFFFFFFFFFL;
            if (colType == 0x6000000000000000L) {
                this.source.skipToPrefix(seekRange.getStartKey(), 0x4000000000000000L);
                continue;
            }
            if (colType == 0x4000000000000000L) {
                long timePtr = WriteValue.getTimestamp(this.source.getTopValue().get());
                if (timePtr > invalidationTime) {
                    invalidationTime = timePtr;
                }
                if (ts >= this.snaptime) {
                    this.hasTop = true;
                    return;
                }
                this.source.skipToPrefix(seekRange.getStartKey(), 0x2000000000000000L);
                continue;
            }
            if (colType == 0x2000000000000000L) {
                if (ts > invalidationTime) {
                    invalidationTime = ts;
                    if (ts >= this.snaptime) {
                        this.hasTop = true;
                        return;
                    }
                }
                this.source.skipToPrefix(seekRange.getStartKey(), -2305843009213693952L);
                continue;
            }
            if (colType == -2305843009213693952L) {
                if (ts > invalidationTime) {
                    this.hasTop = true;
                    return;
                }
                if (this.checkAck) {
                    this.source.skipToPrefix(seekRange.getStartKey(), -4611686018427387904L);
                    continue;
                }
                return;
            }
            if (colType == -6917529027641081856L) {
                return;
            }
            if (colType == -4611686018427387904L) {
                if (this.checkAck && ts > this.ntfyTimestamp) {
                    this.hasTop = true;
                    return;
                }
                return;
            }
            throw new IllegalArgumentException();
        }
    }

    public Key getTopKey() {
        return this.source.getTopKey();
    }

    public Value getTopValue() {
        return this.source.getTopValue();
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        return null;
    }
}

