/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fluo.accumulo.format;

import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.fluo.accumulo.util.NotificationUtil;
import org.apache.fluo.accumulo.values.DelLockValue;
import org.apache.fluo.accumulo.values.LockValue;
import org.apache.fluo.accumulo.values.WriteValue;
import org.apache.fluo.api.data.Bytes;
import org.apache.fluo.api.data.Column;

public class FluoFormatter {
    private static void appendByte(StringBuilder sb, byte b) {
        if (b >= 32 && b <= 126 && b != 92) {
            sb.append((char)b);
        } else {
            sb.append(String.format("\\x%02x", b & 0xFF));
        }
    }

    public static void encNonAscii(StringBuilder sb, byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            FluoFormatter.appendByte(sb, bytes[i]);
        }
    }

    public static void encNonAscii(StringBuilder sb, ByteSequence bytes) {
        for (int i = 0; i < bytes.length(); ++i) {
            FluoFormatter.appendByte(sb, bytes.byteAt(i));
        }
    }

    public static void encNonAscii(StringBuilder sb, Bytes bytes) {
        for (int i = 0; i < bytes.length(); ++i) {
            FluoFormatter.appendByte(sb, bytes.byteAt(i));
        }
    }

    public static String toString(Map.Entry<Key, Value> entry) {
        String val;
        Key key = entry.getKey();
        if (NotificationUtil.isNtfy(key)) {
            StringBuilder sb = new StringBuilder();
            FluoFormatter.encNonAscii(sb, key.getRowData());
            sb.append(" ");
            FluoFormatter.encNonAscii(sb, key.getColumnFamilyData());
            sb.append(":");
            Column col = NotificationUtil.decodeCol(key);
            FluoFormatter.encNonAscii(sb, col.getFamily());
            sb.append(":");
            FluoFormatter.encNonAscii(sb, col.getQualifier());
            sb.append(" [");
            FluoFormatter.encNonAscii(sb, key.getColumnVisibilityData());
            sb.append("] ");
            sb.append(NotificationUtil.decodeTs(key));
            sb.append('-');
            sb.append(NotificationUtil.isDelete(key) ? "DELETE" : "INSERT");
            sb.append("\t");
            FluoFormatter.encNonAscii(sb, entry.getValue().get());
            return sb.toString();
        }
        long ts = key.getTimestamp();
        String type = "";
        if ((ts & 0xE000000000000000L) == 0x6000000000000000L) {
            type = "TX_DONE";
        }
        if ((ts & 0xE000000000000000L) == 0x2000000000000000L) {
            type = "DEL_LOCK";
        }
        if ((ts & 0xE000000000000000L) == -2305843009213693952L) {
            type = "LOCK";
        }
        if ((ts & 0xE000000000000000L) == -6917529027641081856L) {
            type = "DATA";
        }
        if ((ts & 0xE000000000000000L) == 0x4000000000000000L) {
            type = "WRITE";
        }
        if ((ts & 0xE000000000000000L) == -4611686018427387904L) {
            type = "ACK";
        }
        StringBuilder sb = new StringBuilder();
        if (type.equals("WRITE")) {
            val = new WriteValue(entry.getValue().get()).toString();
        } else if (type.equals("DEL_LOCK")) {
            val = new DelLockValue(entry.getValue().get()).toString();
        } else if (type.equals("LOCK")) {
            val = new LockValue(entry.getValue().get()).toString();
        } else {
            FluoFormatter.encNonAscii(sb, entry.getValue().get());
            val = sb.toString();
        }
        sb.setLength(0);
        FluoFormatter.encNonAscii(sb, key.getRowData());
        sb.append(" ");
        FluoFormatter.encNonAscii(sb, key.getColumnFamilyData());
        sb.append(":");
        FluoFormatter.encNonAscii(sb, key.getColumnQualifierData());
        sb.append(" [");
        FluoFormatter.encNonAscii(sb, key.getColumnVisibilityData());
        sb.append("] ");
        sb.append(ts & 0x1FFFFFFFFFFFFFFFL);
        sb.append('-');
        sb.append(type);
        sb.append("\t");
        sb.append(val);
        return sb.toString();
    }
}

