/*
 * Decompiled with CFR 0.152.
 */
package org.apache.falcon.aspect;

import java.util.HashMap;
import java.util.Map;
import org.apache.falcon.aspect.AlertMessage;
import org.apache.falcon.aspect.AuditMessage;
import org.apache.falcon.aspect.ResourceMessage;
import org.apache.falcon.util.ResourcesReflectionUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public abstract class AbstractFalconAspect {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractFalconAspect.class);

    @Around(value="@annotation(org.apache.falcon.monitors.Monitored)")
    public Object logAroundMonitored(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        long startTime = System.nanoTime();
        try {
            result = joinPoint.proceed();
        }
        catch (Exception e) {
            long endTime = System.nanoTime();
            ResourceMessage.Status status = ResourceMessage.Status.FAILED;
            this.publishMessage(this.getResourceMessage(joinPoint.getSignature().getDeclaringType().getSimpleName() + "." + methodName, args, status, endTime - startTime));
            throw e;
        }
        long endTime = System.nanoTime();
        ResourceMessage.Status status = ResourceMessage.Status.SUCCEEDED;
        this.publishMessage(this.getResourceMessage(joinPoint.getSignature().getDeclaringType().getSimpleName() + "." + methodName, args, status, endTime - startTime));
        return result;
    }

    private ResourceMessage getResourceMessage(String methodName, Object[] args, ResourceMessage.Status status, long executionTime) {
        String action = ResourcesReflectionUtil.getResourceMonitorName(methodName);
        assert (action != null) : "Method :" + methodName + " not parsed by reflection util";
        HashMap<String, String> dimensions = new HashMap<String, String>();
        if (ResourcesReflectionUtil.getResourceDimensionsName(methodName) == null) {
            LOG.warn("Class for method name: {} is not added to ResourcesReflectionUtil", (Object)methodName);
        } else {
            for (Map.Entry<Integer, String> param : ResourcesReflectionUtil.getResourceDimensionsName(methodName).entrySet()) {
                dimensions.put(param.getValue(), args[param.getKey()] == null ? "NULL" : args[param.getKey()].toString());
            }
        }
        Integer timeTakenArg = ResourcesReflectionUtil.getResourceTimeTakenName(methodName);
        return timeTakenArg == null ? new ResourceMessage(action, dimensions, status, executionTime) : new ResourceMessage(action, dimensions, status, Long.valueOf(args[timeTakenArg].toString()));
    }

    public abstract void publishMessage(ResourceMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.apache.falcon.monitors.Alert)")
    public Object logAroundAlert(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        String methodName = joinPoint.getSignature().getName();
        String event = ResourcesReflectionUtil.getResourceMonitorName(joinPoint.getSignature().getDeclaringType().getSimpleName() + "." + methodName);
        Object[] args = joinPoint.getArgs();
        try {
            result = joinPoint.proceed();
        }
        finally {
            AlertMessage alertMessage = new AlertMessage(event, args[0].toString(), args[1].toString());
            this.publishAlert(alertMessage);
        }
        return result;
    }

    public abstract void publishAlert(AlertMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(org.apache.falcon.monitors.Auditable)")
    public Object logAroundAudit(ProceedingJoinPoint joinPoint) throws Throwable {
        Object result;
        Object[] args = joinPoint.getArgs();
        try {
            result = joinPoint.proceed();
        }
        finally {
            AuditMessage auditMessage = new AuditMessage(this.getStringValue(args[0], "Unknown-User"), this.getStringValue(args[1], "Unknown-Address"), this.getStringValue(args[2], "Unknown-Host"), this.getStringValue(args[3], "Unknown-URL"), this.getStringValue(args[4], "Unknown-Address"), this.getStringValue(args[5], "Unknown-Time"));
            this.publishAudit(auditMessage);
        }
        return result;
    }

    private String getStringValue(Object value, String defaultValue) {
        return value == null ? defaultValue : value.toString();
    }

    public abstract void publishAudit(AuditMessage var1);
}

