/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.support;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.RpcInvocation;

public class RpcUtils {
    private static final Logger logger = LoggerFactory.getLogger(RpcUtils.class);
    private static final AtomicLong INVOKE_ID = new AtomicLong(0L);

    public static Class<?> getReturnType(Invocation invocation) {
        try {
            String service;
            if (invocation != null && invocation.getInvoker() != null && invocation.getInvoker().getUrl() != null && !invocation.getMethodName().startsWith("$") && StringUtils.isNotEmpty(service = invocation.getInvoker().getUrl().getServiceInterface())) {
                Class<?> invokerInterface = invocation.getInvoker().getInterface();
                Class<?> cls = invokerInterface != null ? ReflectUtils.forName(invokerInterface.getClassLoader(), service) : ReflectUtils.forName(service);
                Method method = cls.getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                if (method.getReturnType() == Void.TYPE) {
                    return null;
                }
                return method.getReturnType();
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        return null;
    }

    public static Type[] getReturnTypes(Invocation invocation) {
        try {
            String service;
            if (invocation != null && invocation.getInvoker() != null && invocation.getInvoker().getUrl() != null && !invocation.getMethodName().startsWith("$") && StringUtils.isNotEmpty(service = invocation.getInvoker().getUrl().getServiceInterface())) {
                Class<?> invokerInterface = invocation.getInvoker().getInterface();
                Class<?> cls = invokerInterface != null ? ReflectUtils.forName(invokerInterface.getClassLoader(), service) : ReflectUtils.forName(service);
                Method method = cls.getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                if (method.getReturnType() == Void.TYPE) {
                    return null;
                }
                Class returnType = method.getReturnType();
                Type genericReturnType = method.getGenericReturnType();
                if (Future.class.isAssignableFrom(returnType)) {
                    if (genericReturnType instanceof ParameterizedType) {
                        Type actualArgType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0];
                        if (actualArgType instanceof ParameterizedType) {
                            returnType = (Class)((ParameterizedType)actualArgType).getRawType();
                            genericReturnType = actualArgType;
                        } else {
                            returnType = (Class)actualArgType;
                            genericReturnType = returnType;
                        }
                    } else {
                        returnType = null;
                        genericReturnType = null;
                    }
                }
                return new Type[]{returnType, genericReturnType};
            }
        }
        catch (Throwable t) {
            logger.warn(t.getMessage(), t);
        }
        return null;
    }

    public static Long getInvocationId(Invocation inv) {
        String id = inv.getAttachment("id");
        return id == null ? null : new Long(id);
    }

    public static void attachInvocationIdIfAsync(URL url, Invocation inv) {
        if (RpcUtils.isAttachInvocationId(url, inv) && RpcUtils.getInvocationId(inv) == null && inv instanceof RpcInvocation) {
            ((RpcInvocation)inv).setAttachment("id", String.valueOf(INVOKE_ID.getAndIncrement()));
        }
    }

    private static boolean isAttachInvocationId(URL url, Invocation invocation) {
        String value = url.getMethodParameter(invocation.getMethodName(), "invocationid.autoattach");
        if (value == null) {
            return RpcUtils.isAsync(url, invocation);
        }
        return Boolean.TRUE.toString().equalsIgnoreCase(value);
    }

    public static String getMethodName(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 0 && invocation.getArguments()[0] instanceof String) {
            return (String)invocation.getArguments()[0];
        }
        return invocation.getMethodName();
    }

    public static Object[] getArguments(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 2 && invocation.getArguments()[2] instanceof Object[]) {
            return (Object[])invocation.getArguments()[2];
        }
        return invocation.getArguments();
    }

    public static Class<?>[] getParameterTypes(Invocation invocation) {
        if ("$invoke".equals(invocation.getMethodName()) && invocation.getArguments() != null && invocation.getArguments().length > 1 && invocation.getArguments()[1] instanceof String[]) {
            String[] types = (String[])invocation.getArguments()[1];
            if (types == null) {
                return new Class[0];
            }
            Class[] parameterTypes = new Class[types.length];
            for (int i = 0; i < types.length; ++i) {
                parameterTypes[i] = ReflectUtils.forName(types[0]);
            }
            return parameterTypes;
        }
        return invocation.getParameterTypes();
    }

    public static boolean isAsync(URL url, Invocation inv) {
        boolean isAsync = Boolean.TRUE.toString().equals(inv.getAttachment("async")) ? true : url.getMethodParameter(RpcUtils.getMethodName(inv), "async", false);
        return isAsync;
    }

    public static boolean isReturnTypeFuture(Invocation inv) {
        return Boolean.TRUE.toString().equals(inv.getAttachment("future_returntype"));
    }

    public static boolean hasFutureReturnType(Method method) {
        return CompletableFuture.class.isAssignableFrom(method.getReturnType());
    }

    public static boolean isOneway(URL url, Invocation inv) {
        boolean isOneway = Boolean.FALSE.toString().equals(inv.getAttachment("return")) ? true : !url.getMethodParameter(RpcUtils.getMethodName(inv), "return", true);
        return isOneway;
    }

    public static Map<String, String> getNecessaryAttachments(Invocation inv) {
        HashMap<String, String> attachments = new HashMap<String, String>(inv.getAttachments());
        attachments.remove("async");
        attachments.remove("future_generated");
        return attachments;
    }
}

