/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.cluster;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.cluster.Router;
import org.apache.dubbo.rpc.cluster.RouterFactory;

public class RouterChain<T> {
    private List<Invoker<T>> invokers = Collections.emptyList();
    private volatile List<Router> routers = Collections.emptyList();
    private List<Router> builtinRouters = Collections.emptyList();

    public static <T> RouterChain<T> buildChain(URL url) {
        return new RouterChain<T>(url);
    }

    private RouterChain(URL url) {
        List<RouterFactory> extensionFactories = ExtensionLoader.getExtensionLoader(RouterFactory.class).getActivateExtension(url, (String[])null);
        List<Router> routers = extensionFactories.stream().map(factory -> factory.getRouter(url)).collect(Collectors.toList());
        this.initWithRouters(routers);
    }

    public void initWithRouters(List<Router> builtinRouters) {
        this.builtinRouters = builtinRouters;
        this.routers = new CopyOnWriteArrayList<Router>(builtinRouters);
        this.sort();
    }

    public void addRouters(List<Router> routers) {
        CopyOnWriteArrayList<Router> newRouters = new CopyOnWriteArrayList<Router>();
        newRouters.addAll(this.builtinRouters);
        newRouters.addAll(routers);
        CollectionUtils.sort(routers);
        this.routers = newRouters;
    }

    private void sort() {
        Collections.sort(this.routers);
    }

    public List<Invoker<T>> route(URL url, Invocation invocation) {
        List<Invoker<T>> finalInvokers = this.invokers;
        for (Router router : this.routers) {
            finalInvokers = router.route(finalInvokers, url, invocation);
        }
        return finalInvokers;
    }

    public void setInvokers(List<Invoker<T>> invokers) {
        this.invokers = invokers == null ? Collections.emptyList() : invokers;
        this.routers.forEach(router -> router.notify(this.invokers));
    }
}

