/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.agent.model.NewService;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import com.ecwid.consul.v1.health.HealthServicesRequest;
import com.ecwid.consul.v1.health.model.HealthService;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NamedThreadFactory;
import org.apache.dubbo.registry.NotifyListener;
import org.apache.dubbo.registry.support.FailbackRegistry;

public class ConsulRegistry
extends FailbackRegistry {
    private static final Logger logger = LoggerFactory.getLogger(ConsulRegistry.class);
    private static final String SERVICE_TAG = "dubbo";
    private static final String URL_META_KEY = "url";
    private static final String WATCH_TIMEOUT = "consul-watch-timeout";
    private static final String CHECK_INTERVAL = "consul-check-interval";
    private static final String CHECK_TIMEOUT = "consul-check-timeout";
    private static final String DEREGISTER_AFTER = "consul-deregister-critical-service-after";
    private static final int DEFAULT_PORT = 8500;
    private static final int DEFAULT_WATCH_TIMEOUT = 60000;
    private static final String DEFAULT_CHECK_INTERVAL = "10s";
    private static final String DEFAULT_CHECK_TIMEOUT = "1s";
    private static final String DEFAULT_DEREGISTER_TIME = "20s";
    private ConsulClient client;
    private ExecutorService notifierExecutor = Executors.newCachedThreadPool(new NamedThreadFactory("dubbo-consul-notifier", true));
    private ConcurrentMap<URL, ConsulNotifier> notifiers = new ConcurrentHashMap<URL, ConsulNotifier>();

    public ConsulRegistry(URL url) {
        super(url);
        String host = url.getHost();
        int port = url.getPort() != 0 ? url.getPort() : 8500;
        this.client = new ConsulClient(host, port);
    }

    @Override
    public void register(URL url) {
        if (this.isConsumerSide(url)) {
            return;
        }
        super.register(url);
    }

    @Override
    public void doRegister(URL url) {
        this.client.agentServiceRegister(this.buildService(url));
    }

    @Override
    public void unregister(URL url) {
        if (this.isConsumerSide(url)) {
            return;
        }
        super.unregister(url);
    }

    @Override
    public void doUnregister(URL url) {
        this.client.agentServiceDeregister(this.buildId(url));
    }

    @Override
    public void subscribe(URL url, NotifyListener listener) {
        if (this.isProviderSide(url)) {
            return;
        }
        super.subscribe(url, listener);
    }

    @Override
    public void doSubscribe(URL url, NotifyListener listener) {
        List<URL> urls;
        Long index;
        if ("*".equals(url.getServiceInterface())) {
            Response<Map<String, List<String>>> response = this.getAllServices(-1L, this.buildWatchTimeout(url));
            index = response.getConsulIndex();
            List<HealthService> services = this.getHealthServices((Map)response.getValue());
            urls = this.convert(services);
        } else {
            String service = url.getServiceKey();
            Response<List<HealthService>> response = this.getHealthServices(service, -1L, this.buildWatchTimeout(url));
            index = response.getConsulIndex();
            urls = this.convert((List)response.getValue());
        }
        this.notify(url, listener, urls);
        ConsulNotifier notifier = this.notifiers.computeIfAbsent(url, k -> new ConsulNotifier(url, index));
        this.notifierExecutor.submit(notifier);
    }

    @Override
    public void unsubscribe(URL url, NotifyListener listener) {
        if (this.isProviderSide(url)) {
            return;
        }
        super.unsubscribe(url, listener);
    }

    @Override
    public void doUnsubscribe(URL url, NotifyListener listener) {
        ConsulNotifier notifier = (ConsulNotifier)this.notifiers.remove(url);
        notifier.stop();
    }

    @Override
    public boolean isAvailable() {
        return this.client.getAgentSelf() != null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.notifierExecutor.shutdown();
    }

    private Response<List<HealthService>> getHealthServices(String service, long index, int watchTimeout) {
        HealthServicesRequest request = HealthServicesRequest.newBuilder().setTag(SERVICE_TAG).setQueryParams(new QueryParams((long)watchTimeout, index)).setPassing(true).build();
        return this.client.getHealthServices(service, request);
    }

    private Response<Map<String, List<String>>> getAllServices(long index, int watchTimeout) {
        CatalogServicesRequest request = CatalogServicesRequest.newBuilder().setQueryParams(new QueryParams((long)watchTimeout, index)).build();
        return this.client.getCatalogServices(request);
    }

    private List<HealthService> getHealthServices(Map<String, List<String>> services) {
        return services.keySet().stream().filter(s -> ((List)services.get(s)).contains(SERVICE_TAG)).map(s -> (List)this.getHealthServices((String)s, -1L, -1).getValue()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private boolean isConsumerSide(URL url) {
        return url.getProtocol().equals("consumer");
    }

    private boolean isProviderSide(URL url) {
        return url.getProtocol().equals("provider");
    }

    private List<URL> convert(List<HealthService> services) {
        return services.stream().map(s -> (String)s.getService().getMeta().get(URL_META_KEY)).map(URL::valueOf).collect(Collectors.toList());
    }

    private NewService buildService(URL url) {
        NewService service = new NewService();
        service.setAddress(url.getHost());
        service.setPort(Integer.valueOf(url.getPort()));
        service.setId(this.buildId(url));
        service.setName(url.getServiceInterface());
        service.setCheck(this.buildCheck(url));
        service.setTags(this.buildTags(url));
        service.setMeta(Collections.singletonMap(URL_META_KEY, url.toFullString()));
        return service;
    }

    private List<String> buildTags(URL url) {
        Map<String, String> params = url.getParameters();
        List<String> tags = params.keySet().stream().map(k -> k + "=" + (String)params.get(k)).collect(Collectors.toList());
        tags.add(SERVICE_TAG);
        return tags;
    }

    private String buildId(URL url) {
        return Integer.toHexString(url.hashCode());
    }

    private NewService.Check buildCheck(URL url) {
        NewService.Check check = new NewService.Check();
        check.setTcp(url.getAddress());
        check.setInterval(url.getParameter(CHECK_INTERVAL, DEFAULT_CHECK_INTERVAL));
        check.setTimeout(url.getParameter(CHECK_TIMEOUT, DEFAULT_CHECK_TIMEOUT));
        check.setDeregisterCriticalServiceAfter(url.getParameter(DEREGISTER_AFTER, DEFAULT_DEREGISTER_TIME));
        return check;
    }

    private int buildWatchTimeout(URL url) {
        return url.getParameter(WATCH_TIMEOUT, 60000) / 1000;
    }

    private class ConsulNotifier
    implements Runnable {
        private URL url;
        private long consulIndex;
        private boolean running;

        ConsulNotifier(URL url, long consulIndex) {
            this.url = url;
            this.consulIndex = consulIndex;
            this.running = true;
        }

        @Override
        public void run() {
            while (this.running) {
                if ("*".equals(this.url.getServiceInterface())) {
                    this.processServices();
                    continue;
                }
                this.processService();
            }
        }

        private void processService() {
            String service = this.url.getServiceKey();
            Response response = ConsulRegistry.this.getHealthServices(service, this.consulIndex, ConsulRegistry.this.buildWatchTimeout(this.url));
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                this.consulIndex = currentIndex;
                List services = (List)response.getValue();
                List urls = ConsulRegistry.this.convert(services);
                for (NotifyListener listener : ConsulRegistry.this.getSubscribed().get(this.url)) {
                    ConsulRegistry.this.doNotify(this.url, listener, urls);
                }
            }
        }

        private void processServices() {
            Response response = ConsulRegistry.this.getAllServices(this.consulIndex, ConsulRegistry.this.buildWatchTimeout(this.url));
            Long currentIndex = response.getConsulIndex();
            if (currentIndex != null && currentIndex > this.consulIndex) {
                this.consulIndex = currentIndex;
                List services = ConsulRegistry.this.getHealthServices((Map)response.getValue());
                List urls = ConsulRegistry.this.convert(services);
                for (NotifyListener listener : ConsulRegistry.this.getSubscribed().get(this.url)) {
                    ConsulRegistry.this.doNotify(this.url, listener, urls);
                }
            }
        }

        void stop() {
            this.running = false;
        }
    }
}

