/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.support;

import com.alibaba.metrics.FastCompass;
import com.alibaba.metrics.MetricLevel;
import com.alibaba.metrics.MetricManager;
import com.alibaba.metrics.MetricName;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.support.RpcUtils;

public class MetricsFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(MetricsFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcContext context = RpcContext.getContext();
        boolean isProvider = context.isProviderSide();
        long start = System.currentTimeMillis();
        try {
            Result result = invoker.invoke(invocation);
            long duration = System.currentTimeMillis() - start;
            this.reportMetrics(invoker, invocation, duration, "success", isProvider);
            return result;
        }
        catch (RpcException e) {
            long duration = System.currentTimeMillis() - start;
            String result = "error";
            if (e.isTimeout()) {
                result = "timeoutError";
            }
            if (e.isBiz()) {
                result = "bisError";
            }
            if (e.isNetwork()) {
                result = "networkError";
            }
            if (e.isSerialization()) {
                result = "serializationError";
            }
            this.reportMetrics(invoker, invocation, duration, result, isProvider);
            throw e;
        }
    }

    private void reportMetrics(Invoker<?> invoker, Invocation invocation, long duration, String result, boolean isProvider) {
        MetricName method;
        MetricName global;
        final String serviceName = invoker.getInterface().getName();
        final String methodName = RpcUtils.getMethodName(invocation);
        if (isProvider) {
            global = new MetricName("dubbo.provider", MetricLevel.MAJOR);
            method = new MetricName("dubbo.provider.method", (Map)new HashMap<String, String>(4){
                {
                    super(x0);
                    this.put("service", serviceName);
                    this.put("method", methodName);
                }
            }, MetricLevel.NORMAL);
        } else {
            global = new MetricName("dubbo.consumer", MetricLevel.MAJOR);
            method = new MetricName("dubbo.consumer.method", (Map)new HashMap<String, String>(4){
                {
                    super(x0);
                    this.put("service", serviceName);
                    this.put("method", methodName);
                }
            }, MetricLevel.NORMAL);
        }
        this.setCompassQuantity("dubbo", result, duration, global, method);
    }

    private void setCompassQuantity(String groupName, String result, long duration, MetricName ... metricNames) {
        for (MetricName metricName : metricNames) {
            FastCompass compass = MetricManager.getFastCompass((String)groupName, (MetricName)metricName);
            compass.record(duration, result);
        }
    }
}

