/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.store.zookeeper;

import java.util.List;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.metadata.identifier.MetadataIdentifier;
import org.apache.dubbo.metadata.support.AbstractMetadataReport;
import org.apache.dubbo.remoting.zookeeper.ZookeeperClient;
import org.apache.dubbo.remoting.zookeeper.ZookeeperTransporter;

public class ZookeeperMetadataReport
extends AbstractMetadataReport {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperMetadataReport.class);
    private static final String DEFAULT_ROOT = "dubbo";
    private static final String METADATA_NODE_NAME = "service.data";
    private final String root;
    final ZookeeperClient zkClient;

    public ZookeeperMetadataReport(URL url, ZookeeperTransporter zookeeperTransporter) {
        super(url);
        if (url.isAnyHost()) {
            throw new IllegalStateException("registry address == null");
        }
        String group = url.getParameter("group", DEFAULT_ROOT);
        if (!group.startsWith("/")) {
            group = "/" + group;
        }
        this.root = group;
        this.zkClient = zookeeperTransporter.connect(url);
    }

    void deletePath(String category) {
        List<String> urlStrs = this.zkClient.getChildren(category);
        if (CollectionUtils.isEmpty(urlStrs)) {
            return;
        }
        for (String urlStr : urlStrs) {
            this.zkClient.delete(category + "/" + urlStr);
        }
    }

    String toRootDir() {
        if (this.root.equals("/")) {
            return this.root;
        }
        return this.root + "/";
    }

    @Override
    protected void doStoreProviderMetadata(MetadataIdentifier providerMetadataIdentifier, String serviceDefinitions) {
        this.storeMetadata(providerMetadataIdentifier, serviceDefinitions);
    }

    @Override
    protected void doStoreConsumerMetadata(MetadataIdentifier consumerMetadataIdentifier, String value) {
        this.storeMetadata(consumerMetadataIdentifier, value);
    }

    private void storeMetadata(MetadataIdentifier metadataIdentifier, String v) {
        this.zkClient.create(this.getNodePath(metadataIdentifier), v, false);
    }

    String getNodePath(MetadataIdentifier metadataIdentifier) {
        return this.toRootDir() + metadataIdentifier.getUniqueKey(MetadataIdentifier.KeyTypeEnum.PATH) + "/" + METADATA_NODE_NAME;
    }
}

