/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.config;

public interface Configuration {
    default public String getString(String key) {
        return this.convert(String.class, key, null);
    }

    default public String getString(String key, String defaultValue) {
        return this.convert(String.class, key, defaultValue);
    }

    default public Object getProperty(String key) {
        return this.getProperty(key, null);
    }

    default public Object getProperty(String key, Object defaultValue) {
        Object value = this.getInternalProperty(key);
        return value != null ? value : defaultValue;
    }

    public Object getInternalProperty(String var1);

    default public boolean containsKey(String key) {
        return this.getProperty(key) != null;
    }

    default public <T> T convert(Class<T> cls, String key, T defaultValue) {
        String value = (String)this.getProperty(key);
        if (value == null) {
            return defaultValue;
        }
        Object obj = value;
        if (cls.isInstance(value)) {
            return cls.cast(value);
        }
        if (String.class.equals(cls)) {
            return cls.cast(value);
        }
        if (Boolean.class.equals(cls) || Boolean.TYPE.equals(cls)) {
            obj = Boolean.valueOf(value);
        } else if (Number.class.isAssignableFrom(cls) || cls.isPrimitive()) {
            if (Integer.class.equals(cls) || Integer.TYPE.equals(cls)) {
                obj = Integer.valueOf(value);
            } else if (Long.class.equals(cls) || Long.TYPE.equals(cls)) {
                obj = Long.valueOf(value);
            } else if (Byte.class.equals(cls) || Byte.TYPE.equals(cls)) {
                obj = Byte.valueOf(value);
            } else if (Short.class.equals(cls) || Short.TYPE.equals(cls)) {
                obj = Short.valueOf(value);
            } else if (Float.class.equals(cls) || Float.TYPE.equals(cls)) {
                obj = Float.valueOf(value);
            } else if (Double.class.equals(cls) || Double.TYPE.equals(cls)) {
                obj = Double.valueOf(value);
            }
        } else if (cls.isEnum()) {
            obj = Enum.valueOf(cls.asSubclass(Enum.class), value);
        }
        return cls.cast(obj);
    }
}

