/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.monitor.dubbo;

import org.apache.dubbo.common.URL;
import org.apache.dubbo.monitor.Monitor;
import org.apache.dubbo.monitor.MonitorService;
import org.apache.dubbo.monitor.dubbo.DubboMonitor;
import org.apache.dubbo.monitor.support.AbstractMonitorFactory;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Protocol;
import org.apache.dubbo.rpc.ProxyFactory;

public class DubboMonitorFactory
extends AbstractMonitorFactory {
    private Protocol protocol;
    private ProxyFactory proxyFactory;

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProxyFactory(ProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    @Override
    protected Monitor createMonitor(URL url) {
        String filter;
        if ((url = url.setProtocol(url.getParameter("protocol", "dubbo"))).getPath() == null || url.getPath().length() == 0) {
            url = url.setPath(MonitorService.class.getName());
        }
        filter = (filter = url.getParameter("reference.filter")) == null || filter.length() == 0 ? "" : filter + ",";
        url = url.addParameters("cluster", "failsafe", "check", String.valueOf(false), "reference.filter", filter + "-monitor");
        Invoker<MonitorService> monitorInvoker = this.protocol.refer(MonitorService.class, url);
        MonitorService monitorService = this.proxyFactory.getProxy(monitorInvoker);
        return new DubboMonitor(monitorInvoker, monitorService);
    }
}

