/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class DSETypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.20";
    private static final String[] DSE_BITS_STRINGS = new String[]{"root", "glue", "cp", "entry", "alias", "subr", "nssr", "supr", "xr", "admPoint", "subentry", "shadow", "zombie", "immSupr", "rhob", "sa"};
    private static final Set<String> DSE_BITS = new HashSet<String>();

    public DSETypeSyntaxChecker() {
        super(SC_OID);
    }

    protected DSETypeSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 4) {
            return false;
        }
        if (strValue.charAt(0) != '(' || strValue.charAt(strValue.length() - 1) != ')') {
            return false;
        }
        HashSet<String> keywords = new HashSet<String>();
        int len = strValue.length() - 1;
        boolean needKeyword = true;
        int i = 1;
        while (i < len) {
            while (i < len && strValue.charAt(i) == ' ') {
                ++i;
            }
            int pos = i;
            while (i < len && StringTools.isAlphaASCII(strValue, pos)) {
                ++pos;
            }
            if (pos == i) {
                return false;
            }
            String keyword = strValue.substring(i, pos);
            if (!DSE_BITS.contains(keyword)) {
                return false;
            }
            if (keywords.contains(keyword)) {
                return false;
            }
            keywords.add(keyword);
            needKeyword = false;
            for (i = pos; i < len && strValue.charAt(i) == ' '; ++i) {
            }
            if (i >= len || strValue.charAt(i) != '$') continue;
            ++i;
            needKeyword = true;
        }
        return !needKeyword;
    }

    static {
        for (String country : DSE_BITS_STRINGS) {
            DSE_BITS.add(country);
        }
    }
}

