/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parser;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.shared.ldap.schema.parser.AttributeTypeLiteral;
import org.apache.directory.shared.ldap.schema.parser.ObjectClassLiteral;
import org.apache.directory.shared.ldap.schema.syntax.AbstractSchemaDescription;
import org.apache.directory.shared.ldap.schema.syntax.AttributeTypeDescription;
import org.apache.directory.shared.ldap.schema.syntax.ObjectClassDescription;
import org.apache.directory.shared.ldap.schema.syntax.OpenLdapObjectIdentifierMacro;
import org.apache.directory.shared.ldap.schema.syntax.parser.AbstractSchemaParser;
import org.apache.directory.shared.ldap.util.ExceptionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenLdapSchemaParser
extends AbstractSchemaParser {
    private List<Object> schemaDescriptions;
    private List<AttributeTypeLiteral> attributeTypeLiterals;
    private List<ObjectClassLiteral> objectClassLiterals;
    private Map<String, OpenLdapObjectIdentifierMacro> objectIdentifierMacros;
    private boolean isResolveObjectIdentifierMacros = true;

    public OpenLdapSchemaParser() throws IOException {
        super.setQuirksMode(true);
    }

    public void clear() {
    }

    public List<AttributeTypeLiteral> getAttributeTypes() {
        return this.attributeTypeLiterals;
    }

    public List<ObjectClassLiteral> getObjectClassTypes() {
        return this.objectClassLiterals;
    }

    public Map<String, OpenLdapObjectIdentifierMacro> getObjectIdentifierMacros() {
        return this.objectIdentifierMacros;
    }

    private void afterParse() throws ParseException {
        this.objectClassLiterals = new ArrayList<ObjectClassLiteral>();
        this.attributeTypeLiterals = new ArrayList<AttributeTypeLiteral>();
        this.objectIdentifierMacros = new HashMap<String, OpenLdapObjectIdentifierMacro>();
        for (Object obj : this.schemaDescriptions) {
            Object literal;
            if (obj instanceof OpenLdapObjectIdentifierMacro) {
                OpenLdapObjectIdentifierMacro oid = (OpenLdapObjectIdentifierMacro)obj;
                this.objectIdentifierMacros.put(oid.getName(), oid);
                continue;
            }
            if (obj instanceof AttributeTypeDescription) {
                AttributeTypeDescription atd = (AttributeTypeDescription)obj;
                literal = new AttributeTypeLiteral(atd.getNumericOid());
                ((AttributeTypeLiteral)literal).setNames(atd.getNames().toArray(new String[atd.getNames().size()]));
                ((AttributeTypeLiteral)literal).setDescription(atd.getDescription());
                ((AttributeTypeLiteral)literal).setSuperior(atd.getSuperType());
                ((AttributeTypeLiteral)literal).setEquality(atd.getEqualityMatchingRule());
                ((AttributeTypeLiteral)literal).setOrdering(atd.getOrderingMatchingRule());
                ((AttributeTypeLiteral)literal).setSubstr(atd.getSubstringsMatchingRule());
                ((AttributeTypeLiteral)literal).setSyntax(atd.getSyntax());
                ((AttributeTypeLiteral)literal).setLength(atd.getSyntaxLength());
                ((AttributeTypeLiteral)literal).setObsolete(atd.isObsolete());
                ((AttributeTypeLiteral)literal).setCollective(atd.isCollective());
                ((AttributeTypeLiteral)literal).setSingleValue(atd.isSingleValued());
                ((AttributeTypeLiteral)literal).setNoUserModification(!atd.isUserModifiable());
                ((AttributeTypeLiteral)literal).setUsage(atd.getUsage());
                this.attributeTypeLiterals.add((AttributeTypeLiteral)literal);
                continue;
            }
            if (!(obj instanceof ObjectClassDescription)) continue;
            ObjectClassDescription ocd = (ObjectClassDescription)obj;
            literal = new ObjectClassLiteral(ocd.getNumericOid());
            ((ObjectClassLiteral)literal).setNames(ocd.getNames().toArray(new String[ocd.getNames().size()]));
            ((ObjectClassLiteral)literal).setDescription(ocd.getDescription());
            ((ObjectClassLiteral)literal).setSuperiors(ocd.getSuperiorObjectClasses().toArray(new String[ocd.getSuperiorObjectClasses().size()]));
            ((ObjectClassLiteral)literal).setMay(ocd.getMayAttributeTypes().toArray(new String[ocd.getMayAttributeTypes().size()]));
            ((ObjectClassLiteral)literal).setMust(ocd.getMustAttributeTypes().toArray(new String[ocd.getMustAttributeTypes().size()]));
            ((ObjectClassLiteral)literal).setClassType(ocd.getKind());
            ((ObjectClassLiteral)literal).setObsolete(ocd.isObsolete());
            this.objectClassLiterals.add((ObjectClassLiteral)literal);
        }
        if (this.isResolveObjectIdentifierMacros()) {
            for (OpenLdapObjectIdentifierMacro oid : this.objectIdentifierMacros.values()) {
                this.resolveObjectIdentifierMacro(oid);
            }
            for (ObjectClassLiteral ocl : this.objectClassLiterals) {
                ocl.setOid(this.getResolveOid(ocl.getOid()));
            }
            for (AttributeTypeLiteral atl : this.attributeTypeLiterals) {
                atl.setOid(this.getResolveOid(atl.getOid()));
                atl.setSyntax(this.getResolveOid(atl.getSyntax()));
            }
        }
    }

    private String getResolveOid(String oid) {
        String[] nameAndSuffix;
        if (oid != null && oid.indexOf(58) != -1 && this.objectIdentifierMacros.containsKey((nameAndSuffix = oid.split(":"))[0])) {
            OpenLdapObjectIdentifierMacro macro = this.objectIdentifierMacros.get(nameAndSuffix[0]);
            return macro.getResolvedOid() + "." + nameAndSuffix[1];
        }
        return oid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveObjectIdentifierMacro(OpenLdapObjectIdentifierMacro macro) throws ParseException {
        String rawOidOrNameSuffix = macro.getRawOidOrNameSuffix();
        if (macro.isResolved()) return;
        if (rawOidOrNameSuffix.indexOf(58) != -1) {
            String[] nameAndSuffix = rawOidOrNameSuffix.split(":");
            if (!this.objectIdentifierMacros.containsKey(nameAndSuffix[0])) throw new ParseException("No object identifier macro with name " + nameAndSuffix[0], 0);
            OpenLdapObjectIdentifierMacro parentMacro = this.objectIdentifierMacros.get(nameAndSuffix[0]);
            this.resolveObjectIdentifierMacro(parentMacro);
            macro.setResolvedOid(parentMacro.getResolvedOid() + "." + nameAndSuffix[1]);
            return;
        } else if (this.objectIdentifierMacros.containsKey(rawOidOrNameSuffix)) {
            OpenLdapObjectIdentifierMacro parentMacro = this.objectIdentifierMacros.get(rawOidOrNameSuffix);
            this.resolveObjectIdentifierMacro(parentMacro);
            macro.setResolvedOid(parentMacro.getResolvedOid());
            return;
        } else {
            macro.setResolvedOid(rawOidOrNameSuffix);
        }
    }

    @Override
    public AbstractSchemaDescription parse(String schemaObject) throws ParseException {
        if (schemaObject == null || schemaObject.trim().equals("")) {
            throw new ParseException("The schemaObject is either null or is the empty String!", 0);
        }
        this.reset(schemaObject);
        this.invokeParser(schemaObject);
        if (!this.schemaDescriptions.isEmpty()) {
            for (Object obj : this.schemaDescriptions) {
                if (!(obj instanceof AbstractSchemaDescription)) continue;
                return (AbstractSchemaDescription)obj;
            }
        }
        return null;
    }

    private void invokeParser(String subject) throws ParseException {
        try {
            this.monitor.startedParse("starting parse on:\n" + subject);
            this.schemaDescriptions = this.parser.openLdapSchema();
            this.afterParse();
            this.monitor.finishedParse("Done parsing!");
        }
        catch (RecognitionException e) {
            String msg = "Parser failure on:\n\t" + subject;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e);
            throw new ParseException(msg, e.getColumn());
        }
        catch (TokenStreamException e2) {
            String msg = "Parser failure on:\n\t" + subject;
            msg = msg + "\nAntlr exception trace:\n" + ExceptionUtils.getFullStackTrace(e2);
            throw new ParseException(msg, 0);
        }
    }

    public void parse(InputStream schemaIn) throws IOException, ParseException {
        InputStreamReader in = new InputStreamReader(schemaIn);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
        this.invokeParser("schema input stream ==> " + schemaIn.toString());
    }

    public void parse(File schemaFile) throws IOException, ParseException {
        FileReader in = new FileReader(schemaFile);
        this.lexer.prepareNextInput(in);
        this.parser.resetState();
        this.invokeParser("schema file ==> " + schemaFile.getAbsolutePath());
    }

    public boolean isResolveObjectIdentifierMacros() {
        return this.isResolveObjectIdentifierMacros;
    }

    public void setResolveObjectIdentifierMacros(boolean isResolveObjectIdentifierMacros) {
        this.isResolveObjectIdentifierMacros = isResolveObjectIdentifierMacros;
    }
}

