/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import org.apache.directory.shared.ldap.filter.AssertionType;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringNode
extends LeafNode {
    private String initialPattern;
    private String finalPattern;
    private List<String> anyPattern;

    public SubstringNode(String attribute, String initialPattern, String finalPattern) {
        super(attribute, AssertionType.SUBSTRING);
        this.anyPattern = new ArrayList<String>(2);
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public SubstringNode(String attribute) {
        super(attribute, AssertionType.SUBSTRING);
        this.anyPattern = new ArrayList<String>(2);
        this.finalPattern = null;
        this.initialPattern = null;
    }

    public SubstringNode(List<String> anyPattern, String attribute, String initialPattern, String finalPattern) {
        super(attribute, AssertionType.SUBSTRING);
        this.anyPattern = anyPattern;
        this.finalPattern = finalPattern;
        this.initialPattern = initialPattern;
    }

    public final String getInitial() {
        return this.initialPattern;
    }

    public void setInitial(String initialPattern) {
        this.initialPattern = initialPattern;
    }

    public final String getFinal() {
        return this.finalPattern;
    }

    public void setFinal(String finalPattern) {
        this.finalPattern = finalPattern;
    }

    public final List<String> getAny() {
        return this.anyPattern;
    }

    public void setAny(List<String> anyPattern) {
        this.anyPattern = anyPattern;
    }

    public void addAny(String anyPattern) {
        this.anyPattern.add(anyPattern);
    }

    public final Pattern getRegex(Normalizer normalizer) throws NamingException {
        if (this.anyPattern != null && this.anyPattern.size() > 0) {
            String[] any = new String[this.anyPattern.size()];
            for (int i = 0; i < any.length; ++i) {
                any[i] = (String)normalizer.normalize(this.anyPattern.get(i));
                if (any[i].length() != 0) continue;
                any[i] = " ";
            }
            String initialStr = null;
            if (this.initialPattern != null) {
                initialStr = (String)normalizer.normalize(this.initialPattern);
            }
            String finalStr = null;
            if (this.finalPattern != null) {
                finalStr = (String)normalizer.normalize(this.finalPattern);
            }
            return StringTools.getRegex(initialStr, any, finalStr);
        }
        String initialStr = null;
        if (this.initialPattern != null) {
            initialStr = (String)normalizer.normalize(this.initialPattern);
        }
        String finalStr = null;
        if (this.finalPattern != null) {
            finalStr = (String)normalizer.normalize(this.finalPattern);
        }
        return StringTools.getRegex(initialStr, null, finalStr);
    }

    @Override
    public int hashCode() {
        int h = 37;
        h = h * 17 + super.hashCode();
        h = h * 17 + (this.initialPattern != null ? this.initialPattern.hashCode() : 0);
        if (this.anyPattern != null) {
            for (String pattern : this.anyPattern) {
                h = h * 17 + pattern.hashCode();
            }
        }
        h = h * 17 + (this.finalPattern != null ? this.finalPattern.hashCode() : 0);
        return h;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('(').append(this.getAttribute()).append('=');
        if (null != this.initialPattern) {
            buf.append(this.initialPattern).append('*');
        } else {
            buf.append('*');
        }
        if (null != this.anyPattern) {
            for (String any : this.anyPattern) {
                buf.append(any);
                buf.append('*');
            }
        }
        if (null != this.finalPattern) {
            buf.append(this.finalPattern);
        }
        buf.append(super.toString());
        buf.append(')');
        return buf.toString();
    }
}

