/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.extended.operations;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.extended.operations.GracefulAction;
import org.apache.directory.shared.ldap.util.LdapURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GracefulDisconnect
extends GracefulAction {
    private List<LdapURL> replicatedContexts = new ArrayList<LdapURL>(2);
    private int gracefulDisconnectSequenceLength;
    private int replicatedContextsLength;

    public GracefulDisconnect(int timeOffline, int delay) {
        super(timeOffline, delay);
    }

    public GracefulDisconnect() {
    }

    public List<LdapURL> getReplicatedContexts() {
        return this.replicatedContexts;
    }

    public void addReplicatedContexts(LdapURL replicatedContext) {
        this.replicatedContexts.add(replicatedContext);
    }

    public int computeLength() {
        this.gracefulDisconnectSequenceLength = 0;
        if (this.timeOffline != 0) {
            this.gracefulDisconnectSequenceLength += 2 + Value.getNbBytes((int)this.timeOffline);
        }
        if (this.delay != 0) {
            this.gracefulDisconnectSequenceLength += 2 + Value.getNbBytes((int)this.delay);
        }
        if (this.replicatedContexts.size() > 0) {
            this.replicatedContextsLength = 0;
            for (LdapURL replicatedContext : this.replicatedContexts) {
                int ldapUrlLength = replicatedContext.getNbBytes();
                this.replicatedContextsLength += 1 + TLV.getNbBytes((int)ldapUrlLength) + ldapUrlLength;
            }
            this.gracefulDisconnectSequenceLength += 1 + TLV.getNbBytes((int)this.replicatedContextsLength) + this.replicatedContextsLength;
        }
        return 1 + TLV.getNbBytes((int)this.gracefulDisconnectSequenceLength) + this.gracefulDisconnectSequenceLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put((byte)48);
        bb.put(TLV.getBytes((int)this.gracefulDisconnectSequenceLength));
        if (this.timeOffline != 0) {
            Value.encode((ByteBuffer)bb, (int)this.timeOffline);
        }
        if (this.delay != 0) {
            bb.put((byte)-128);
            bb.put((byte)TLV.getNbBytes((int)this.delay));
            bb.put(Value.getBytes((int)this.delay));
        }
        if (this.replicatedContexts.size() != 0) {
            bb.put((byte)48);
            bb.put(TLV.getBytes((int)this.replicatedContextsLength));
            for (LdapURL replicatedContext : this.replicatedContexts) {
                Value.encode((ByteBuffer)bb, (byte[])replicatedContext.getBytesReference());
            }
        }
        return bb;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Graceful Disconnect extended operation");
        sb.append("    TimeOffline : ").append(this.timeOffline).append('\n');
        sb.append("    Delay : ").append(this.delay).append('\n');
        if (this.replicatedContexts != null && this.replicatedContexts.size() != 0) {
            sb.append("    Replicated contexts :");
            for (LdapURL url : this.replicatedContexts) {
                sb.append("\n        ").append(url);
            }
        }
        return sb.toString();
    }
}

