/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.OidRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.syntaxes.NumericOidSyntaxChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameOrNumericIdNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private NumericOidSyntaxChecker checker = new NumericOidSyntaxChecker();
    private transient OidRegistry registry;
    public static final NameOrNumericIdNormalizer INSTANCE = new NameOrNumericIdNormalizer();

    public NameOrNumericIdNormalizer(OidRegistry registry) {
        this.registry = registry;
    }

    public NameOrNumericIdNormalizer() {
    }

    public Value<?> normalize(Value<?> value) throws NamingException {
        if (value == null) {
            return null;
        }
        String strValue = value.getString();
        if (strValue.length() == 0) {
            return new ClientStringValue("");
        }
        if (this.checker.isValidSyntax((Object)strValue)) {
            return value;
        }
        if (this.registry.hasOid(strValue)) {
            return new ClientStringValue(this.registry.getOid(strValue));
        }
        throw new LdapNamingException("Encountered name based id of " + value + " which was not found in the OID registry", ResultCodeEnum.OTHER);
    }

    public String normalize(String value) throws NamingException {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        if (this.checker.isValidSyntax((Object)value)) {
            return value;
        }
        if (this.registry.hasOid(value)) {
            return this.registry.getOid(value);
        }
        throw new LdapNamingException("Encountered name based id of " + value + " which was not found in the OID registry", ResultCodeEnum.OTHER);
    }

    public void setRegistries(Registries registries) {
        this.registry = registries.getOidRegistry();
    }
}

