/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.bootstrap;

import java.util.Comparator;
import javax.naming.NamingException;
import jdbm.helper.StringComparator;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.apache.directory.server.schema.bootstrap.AbstractBootstrapProducer;
import org.apache.directory.server.schema.bootstrap.ApachemetaComparatorProducer;
import org.apache.directory.server.schema.bootstrap.ApachemetaSyntaxProducer;
import org.apache.directory.server.schema.bootstrap.NameOrNumericIdMatch;
import org.apache.directory.server.schema.bootstrap.ProducerCallback;
import org.apache.directory.server.schema.bootstrap.ProducerTypeEnum;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.schema.registries.SyntaxRegistry;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.schema.DeepTrimToLowerNormalizer;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.NoOpNormalizer;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.ObjectIdentifierComparator;
import org.apache.directory.shared.ldap.schema.ObjectIdentifierNormalizer;
import org.apache.directory.shared.ldap.schema.Syntax;

public class ApachemetaMatchingRuleProducer
extends AbstractBootstrapProducer {
    public ApachemetaMatchingRuleProducer() {
        super(ProducerTypeEnum.MATCHING_RULE_PRODUCER);
    }

    public void produce(Registries registries, ProducerCallback cb) throws NamingException {
        Object matchingRule = null;
        matchingRule = new NameOrNumericIdMatch(registries.getOidRegistry(), "apachemeta");
        cb.schemaObjectProduced(this, matchingRule.getOid(), matchingRule);
        matchingRule = new ObjectClassTypeMatch();
        cb.schemaObjectProduced(this, matchingRule.getOid(), matchingRule);
        matchingRule = new NumericOidMatch(registries.getSyntaxRegistry());
        cb.schemaObjectProduced(this, matchingRule.getOid(), matchingRule);
        matchingRule = new SupDITStructureRuleMatch(registries.getSyntaxRegistry());
        cb.schemaObjectProduced(this, matchingRule.getOid(), matchingRule);
        matchingRule = new RuleIdMatch(registries.getSyntaxRegistry());
        cb.schemaObjectProduced(this, matchingRule.getOid(), matchingRule);
    }

    public static class ObjectClassTypeMatch
    implements MatchingRule {
        private static final long serialVersionUID = 1L;
        public static final Comparator COMPARATOR = new ApachemetaComparatorProducer.ObjectClassTypeComparator();
        public static final Normalizer NORMALIZER = new NoOpNormalizer();
        public static final Syntax SYNTAX = new ApachemetaSyntaxProducer.ObjectClassTypeSyntax();
        public static final String OID = "1.3.6.1.4.1.18060.0.4.0.1.1";
        private static final String[] NAMES = new String[]{"objectClassTypeMatch"};

        public Comparator getComparator() throws NamingException {
            return COMPARATOR;
        }

        public Normalizer getNormalizer() throws NamingException {
            return NORMALIZER;
        }

        public Syntax getSyntax() throws NamingException {
            return SYNTAX;
        }

        public String getDescription() {
            return "objectClassTypeMatch: for mathing AUXILIARY, STRUCTURAL, ABSTRACT";
        }

        public String getName() {
            return NAMES[0];
        }

        public String[] getNamesRef() {
            return NAMES;
        }

        public String getOid() {
            return OID;
        }

        public boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class NumericOidMatch
    implements MatchingRule {
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.1.2";
        private static final long serialVersionUID = 1L;
        final String[] NAMES = new String[]{"numericOidMatch"};
        Syntax syntax;

        public NumericOidMatch(SyntaxRegistry registry) throws NamingException {
            this.syntax = registry.lookup("1.3.6.1.4.1.1466.115.121.1.38");
        }

        public Comparator getComparator() throws NamingException {
            return new ObjectIdentifierComparator();
        }

        public Normalizer getNormalizer() throws NamingException {
            return new ObjectIdentifierNormalizer();
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntax;
        }

        public String getDescription() {
            return "a matching rule for numeric oids";
        }

        public String getName() {
            return this.NAMES[0];
        }

        public String[] getNamesRef() {
            return this.NAMES;
        }

        public String getOid() {
            return OID;
        }

        public boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class SupDITStructureRuleMatch
    implements MatchingRule {
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.1.3";
        private static final long serialVersionUID = 1L;
        String[] NAMES = new String[]{"supDITStructureRuleMatch"};
        Syntax syntax;

        public SupDITStructureRuleMatch(SyntaxRegistry registry) throws NamingException {
            this.syntax = registry.lookup("1.3.6.1.4.1.1466.115.121.1.17");
        }

        public Comparator getComparator() throws NamingException {
            return new StringComparator();
        }

        public Normalizer getNormalizer() throws NamingException {
            return new DeepTrimToLowerNormalizer();
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntax;
        }

        public String getDescription() {
            return "A matching rule matching dit structure rule attributes";
        }

        public String getName() {
            return this.NAMES[0];
        }

        public String[] getNamesRef() {
            return this.NAMES;
        }

        public String getOid() {
            return OID;
        }

        public boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }

    public static class RuleIdMatch
    implements MatchingRule {
        private static final long serialVersionUID = 1L;
        private static final String OID = "1.3.6.1.4.1.18060.0.4.0.1.4";
        private final Syntax syntax;
        private final String[] NAMES = new String[]{"ruleIdMatch"};

        RuleIdMatch(SyntaxRegistry registry) throws NamingException {
            this.syntax = registry.lookup("1.3.6.1.4.1.1466.115.121.1.26");
        }

        public Comparator getComparator() throws NamingException {
            return new ComparableComparator();
        }

        public Normalizer getNormalizer() throws NamingException {
            return new DeepTrimToLowerNormalizer();
        }

        public Syntax getSyntax() throws NamingException {
            return this.syntax;
        }

        public String getDescription() {
            return "Rule identifier of this DIT structure rule";
        }

        public String getName() {
            return this.NAMES[0];
        }

        public String[] getNamesRef() {
            return this.NAMES;
        }

        public String getOid() {
            return OID;
        }

        public boolean isObsolete() {
            return false;
        }

        public String getSchema() {
            return "apachemeta";
        }

        public void setSchema(String schemaName) {
            throw new NotImplementedException();
        }
    }
}

