/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSamlPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.TokenPolicyValidator;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.saml.DOMSAMLUtil;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.SamlToken;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;

public class SamlTokenPolicyValidator
extends AbstractSamlPolicyValidator
implements TokenPolicyValidator {
    private Element body;
    private List<WSSecurityEngineResult> signed;

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        this.body = soapBody;
        this.signed = signedResults;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SamlToken");
        if (!ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, results, signedResults);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        ArrayList<Integer> actions = new ArrayList<Integer>(2);
        actions.add(16);
        actions.add(8);
        List samlResults = WSSecurityUtil.fetchAllActionResults(results, actions);
        for (AssertionInfo ai : ais) {
            SamlToken samlToken = (SamlToken)ai.getAssertion();
            ai.setAsserted(true);
            if (!this.isTokenRequired((AbstractToken)samlToken, message)) {
                this.assertPolicy(aim, new QName(samlToken.getVersion().getNamespace(), samlToken.getSamlTokenType().name()));
                continue;
            }
            if (samlResults.isEmpty()) {
                ai.setNotAsserted("The received token does not match the token inclusion requirement");
                continue;
            }
            for (WSSecurityEngineResult result : samlResults) {
                SamlAssertionWrapper assertionWrapper = (SamlAssertionWrapper)result.get((Object)"saml-assertion");
                if (!this.checkVersion(aim, samlToken, assertionWrapper)) {
                    ai.setNotAsserted("Wrong SAML Version");
                    continue;
                }
                TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
                Certificate[] tlsCerts = null;
                if (tlsInfo != null) {
                    tlsCerts = tlsInfo.getPeerCertificates();
                }
                if (!this.checkHolderOfKey(assertionWrapper, signedResults, tlsCerts)) {
                    ai.setNotAsserted("Assertion fails holder-of-key requirements");
                    continue;
                }
                if (DOMSAMLUtil.checkSenderVouches((SamlAssertionWrapper)assertionWrapper, (Certificate[])tlsCerts, (Element)this.body, this.signed)) continue;
                ai.setNotAsserted("Assertion fails sender-vouches requirements");
            }
        }
    }

    private boolean checkVersion(AssertionInfoMap aim, SamlToken samlToken, SamlAssertionWrapper assertionWrapper) {
        SamlToken.SamlTokenType samlTokenType = samlToken.getSamlTokenType();
        if ((samlTokenType == SamlToken.SamlTokenType.WssSamlV11Token10 || samlTokenType == SamlToken.SamlTokenType.WssSamlV11Token11) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
            return false;
        }
        if (samlTokenType == SamlToken.SamlTokenType.WssSamlV20Token11 && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_20) {
            return false;
        }
        if (samlTokenType != null) {
            this.assertPolicy(aim, new QName(samlToken.getVersion().getNamespace(), samlTokenType.name()));
        }
        return true;
    }
}

