/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.jaxrs.impl.AbstractInterceptorContextImpl;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class WriterInterceptorContextImpl
extends AbstractInterceptorContextImpl
implements WriterInterceptorContext {
    private List<WriterInterceptor> writers;
    private OutputStream os;
    private Object entity;

    public WriterInterceptorContextImpl(Object entity, Class<?> cls, Type type, Annotation[] anns, OutputStream os, Message message, List<WriterInterceptor> writers) {
        super(cls, type, anns, message);
        this.entity = entity;
        this.os = os;
        this.writers = writers;
    }

    public Object getEntity() {
        return this.entity;
    }

    public MultivaluedMap<String, Object> getHeaders() {
        return new MetadataMap<String, Object>((Map)this.m.get((Object)Message.PROTOCOL_HEADERS), false, false, true);
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void proceed() throws IOException {
        if (this.writers == null || this.writers.isEmpty()) {
            return;
        }
        WriterInterceptor next = this.writers.remove(0);
        next.aroundWriteTo((WriterInterceptorContext)this);
    }

    public void setEntity(Object object) {
        this.entity = object;
        super.setType(this.entity != null ? this.entity.getClass() : null);
    }

    public void setOutputStream(OutputStream stream) {
        this.os = stream;
        this.m.put(OutputStream.class, (Object)stream);
    }

    public MediaType getMediaType() {
        Object value = this.getHeaders().getFirst((Object)"Content-Type");
        return value instanceof MediaType ? (MediaType)value : JAXRSUtils.toMediaType((String)value);
    }

    public void setMediaType(MediaType mt) {
        if (!this.getMediaType().isCompatible(mt)) {
            this.providerSelectionPropertyChanged();
        }
        this.m.put((Object)"Content-Type", (Object)JAXRSUtils.mediaTypeToString(mt, new String[0]));
        this.getHeaders().putSingle((Object)"Content-Type", (Object)mt);
    }
}

