/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.jsonp;

import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonpInInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String CALLBACK_PARAM = "_jsonp";
    public static final String CALLBACK_KEY = "JSONP.CALLBACK";
    private String callbackParam = "_jsonp";
    private String acceptType;

    public JsonpInInterceptor() {
        this("unmarshal");
    }

    public JsonpInInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        String callbackValue = this.getCallbackValue(message);
        if (!StringUtils.isEmpty((String)callbackValue)) {
            if (this.getAcceptType() != null) {
                message.put((Object)"Accept", (Object)this.getAcceptType());
            }
            message.getExchange().put((Object)CALLBACK_KEY, (Object)callbackValue);
        }
    }

    protected String getCallbackValue(Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        return request.getParameter(this.callbackParam);
    }

    public void setCallbackParam(String callbackParam) {
        this.callbackParam = callbackParam;
    }

    public String getCallbackParam() {
        return this.callbackParam;
    }

    public void setAcceptType(String acceptType) {
        this.acceptType = acceptType;
    }

    public String getAcceptType() {
        return this.acceptType;
    }
}

