/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.SequenceInputStream;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractJAXBProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.schemas.SchemaHandler;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class JSONProvider
extends AbstractJAXBProvider {
    private Map<String, String> namespaceMap = new HashMap<String, String>();
    private boolean serializeAsArray;
    private List<String> arrayKeys;
    private boolean unwrapped;
    private String wrapperName;
    private Map<String, String> wrapperMap;
    private boolean dropRootElement;
    private boolean dropCollectionWrapperElement;
    private boolean ignoreMixedContent;

    @Context
    public void setMessageContext(MessageContext mc) {
        super.setContext(mc);
    }

    public void setDropRootElement(boolean drop) {
        this.dropRootElement = drop;
    }

    public void setDropCollectionWrapperElement(boolean drop) {
        this.dropCollectionWrapperElement = drop;
    }

    public void setIgnoreMixedContent(boolean ignore) {
        this.ignoreMixedContent = ignore;
    }

    public void setSupportUnwrapped(boolean unwrap) {
        this.unwrapped = unwrap;
    }

    public void setWrapperName(String wName) {
        this.wrapperName = wName;
    }

    public void setWrapperMap(Map<String, String> map) {
        this.wrapperMap = map;
    }

    @Override
    public void setEnableBuffering(boolean enableBuf) {
        super.setEnableBuffering(enableBuf);
    }

    @Override
    public void setConsumeMediaTypes(List<String> types) {
        super.setConsumeMediaTypes(types);
    }

    @Override
    public void setProduceMediaTypes(List<String> types) {
        super.setProduceMediaTypes(types);
    }

    public void setSchemas(List<String> locations) {
        super.setSchemaLocations(locations);
    }

    public void setSchemaHandler(SchemaHandler handler) {
        super.setSchema(handler.getSchema());
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setNamespaceMap(Map<String, String> namespaceMap) {
        this.namespaceMap = namespaceMap;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        try {
            Class<?> theType = this.getActualType(type, genericType, anns);
            Unmarshaller unmarshaller = this.createUnmarshaller(theType, genericType);
            InputStream realStream = this.getInputStream(type, genericType, is);
            XMLStreamReader xsw = this.createReader(type, realStream);
            Object response = null;
            response = JAXBElement.class.isAssignableFrom(type) ? unmarshaller.unmarshal(xsw, theType) : unmarshaller.unmarshal(xsw);
            response = this.checkAdapter(response, anns, false);
            return response;
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (WebApplicationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
        return null;
    }

    protected XMLStreamReader createReader(Class<?> type, InputStream is) throws Exception {
        MappedXMLInputFactory factory = new MappedXMLInputFactory(this.namespaceMap);
        return factory.createXMLStreamReader(is);
    }

    protected InputStream getInputStream(Class<Object> cls, Type type, InputStream is) throws Exception {
        if (this.unwrapped) {
            String rootName = this.getRootName(cls, type);
            ByteArrayInputStream isBefore = new ByteArrayInputStream(rootName.getBytes());
            String after = "}";
            ByteArrayInputStream isAfter = new ByteArrayInputStream(after.getBytes());
            final InputStream[] streams = new InputStream[]{isBefore, is, isAfter};
            Enumeration<InputStream> list = new Enumeration<InputStream>(){
                private int index;

                @Override
                public boolean hasMoreElements() {
                    return this.index < streams.length;
                }

                @Override
                public InputStream nextElement() {
                    return streams[this.index++];
                }
            };
            return new SequenceInputStream((Enumeration<? extends InputStream>)list);
        }
        return is;
    }

    protected String getRootName(Class<Object> cls, Type type) throws Exception {
        QName qname;
        String name = null;
        if (this.wrapperName != null) {
            name = this.wrapperName;
        } else if (this.wrapperMap != null) {
            name = this.wrapperMap.get(cls.getName());
        }
        if (name == null && (qname = this.getQName(cls, type, null, false)) != null) {
            name = qname.getLocalPart();
            String prefix = qname.getPrefix();
            if (prefix.length() > 0) {
                name = prefix + "." + name;
            }
        }
        if (name == null) {
            throw new WebApplicationException(500);
        }
        return "{\"" + name + "\":";
    }

    public void writeTo(Object obj, Class<?> cls, Type genericType, Annotation[] anns, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        try {
            String encoding;
            Class<?> actualClass;
            Object actualObject = this.checkAdapter(obj, anns, true);
            Class<?> clazz = actualClass = obj != actualObject ? actualObject.getClass() : cls;
            if (cls == genericType) {
                genericType = actualClass;
            }
            if ((encoding = this.getEncoding(m, headers)) == null) {
                encoding = "UTF-8";
            }
            if (InjectionUtils.isSupportedCollectionOrArray(actualClass)) {
                actualClass = InjectionUtils.getActualType(genericType);
                this.marshalCollection(cls, actualObject, actualClass, genericType, encoding, os, m);
            } else {
                this.marshal(actualObject, actualClass, genericType, encoding, os);
            }
        }
        catch (JAXBException e) {
            JSONProvider.handleJAXBException(e);
        }
        catch (XMLStreamException e) {
            throw new WebApplicationException((Throwable)e);
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    protected void marshalCollection(Class<?> originalCls, Object actualObject, Class<?> actualClass, Type genericType, String encoding, OutputStream os, MediaType m) throws Exception {
        String startTag = null;
        String endTag = null;
        if (!this.dropCollectionWrapperElement) {
            QName qname = this.getCollectionWrapperQName(actualClass, genericType, actualObject, false);
            if (qname == null) {
                String message = new Message("NO_COLLECTION_ROOT", BUNDLE, new Object[0]).toString();
                throw new WebApplicationException(Response.serverError().entity((Object)message).build());
            }
            startTag = qname.getNamespaceURI().length() > 0 ? "{\"ns1." + qname.getLocalPart() + "\":[" : "{\"" + qname.getLocalPart() + "\":[";
            endTag = "]}";
        } else {
            startTag = "{";
            endTag = "}";
        }
        os.write(startTag.getBytes());
        Object[] arr = originalCls.isArray() ? (Object[])actualObject : ((Collection)actualObject).toArray();
        for (int i = 0; i < arr.length; ++i) {
            Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, encoding);
            this.marshal(ms, arr[i], actualClass, genericType, encoding, os, true);
            if (i + 1 >= arr.length) continue;
            os.write(",".getBytes());
        }
        os.write(endTag.getBytes());
    }

    protected void marshal(Marshaller ms, Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        Object writer = this.createWriter(actualObject, actualClass, genericType, enc, os, isCollection);
        if (this.ignoreMixedContent) {
            writer = new IgnoreMixedContentWriter((XMLStreamWriter)writer);
        }
        ms.marshal(actualObject, (XMLStreamWriter)writer);
        writer.close();
    }

    protected XMLStreamWriter createWriter(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os, boolean isCollection) throws Exception {
        QName qname = this.getQName(actualClass, genericType, actualObject, true);
        Configuration c = new Configuration(this.namespaceMap);
        MappedNamespaceConvention convention = new MappedNamespaceConvention(c);
        MappedXMLStreamWriter xsw = new MappedXMLStreamWriter(convention, (Writer)new OutputStreamWriter(os, enc));
        if (this.serializeAsArray) {
            if (this.arrayKeys != null) {
                for (String key : this.arrayKeys) {
                    xsw.seriliazeAsArray(key);
                }
            } else {
                String key = this.getKey(convention, qname);
                xsw.seriliazeAsArray(key);
            }
        }
        return isCollection || this.dropRootElement ? new JSONCollectionWriter((XMLStreamWriter)xsw, qname) : xsw;
    }

    protected void marshal(Object actualObject, Class<?> actualClass, Type genericType, String enc, OutputStream os) throws Exception {
        if ((actualObject = this.convertToJaxbElementIfNeeded(actualObject, actualClass, genericType)) instanceof JAXBElement && actualClass != JAXBElement.class) {
            actualClass = JAXBElement.class;
        }
        Marshaller ms = this.createMarshaller(actualObject, actualClass, genericType, enc);
        this.marshal(ms, actualObject, actualClass, genericType, enc, os, false);
    }

    private String getKey(MappedNamespaceConvention convention, QName qname) throws Exception {
        return convention.createKey(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    private QName getQName(Class<?> cls, Type type, Object object, boolean allocatePrefix) throws Exception {
        QName qname = this.getJaxbQName(cls, type, object, false);
        if (qname != null) {
            String prefix = this.getPrefix(qname.getNamespaceURI(), allocatePrefix);
            return new QName(qname.getNamespaceURI(), qname.getLocalPart(), prefix);
        }
        return null;
    }

    private String getPrefix(String namespace, boolean allocatePrefix) {
        String prefix = this.namespaceMap.get(namespace);
        if (prefix == null) {
            if (allocatePrefix && namespace.length() > 0) {
                prefix = "ns" + (this.namespaceMap.size() + 1);
                this.namespaceMap.put(namespace, prefix);
            } else {
                prefix = "";
            }
        }
        return prefix;
    }

    protected static class IgnoreMixedContentWriter
    extends DelegatingXMLStreamWriter {
        String lastText;
        boolean isMixed;
        List<Boolean> mixed = new LinkedList<Boolean>();

        public IgnoreMixedContentWriter(XMLStreamWriter writer) {
            super(writer);
        }

        public void writeCharacters(String text) throws XMLStreamException {
            if (StringUtils.isEmpty((String)text.trim())) {
                this.lastText = text;
            } else if (this.lastText != null) {
                this.lastText = this.lastText + text;
            } else if (!this.isMixed) {
                super.writeCharacters(text);
            } else {
                this.lastText = text;
            }
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String uri, String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(uri, local);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(local);
        }

        public void writeEndElement() throws XMLStreamException {
            if (!(this.lastText == null || this.isMixed && StringUtils.isEmpty((String)this.lastText.trim()))) {
                super.writeCharacters(this.lastText.trim());
            }
            super.writeEndElement();
            this.isMixed = this.mixed.get(0);
            this.mixed.remove(0);
        }
    }

    protected static class JSONCollectionWriter
    extends DelegatingXMLStreamWriter {
        private QName ignoredQName;

        public JSONCollectionWriter(XMLStreamWriter writer, QName qname) {
            super(writer);
            this.ignoredQName = qname;
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            if (this.ignoredQName.getLocalPart().equals(local) && this.ignoredQName.getNamespaceURI().equals(uri)) {
                return;
            }
            super.writeStartElement(prefix, local, uri);
        }
    }
}

