/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Provider;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.jaxrs.provider.AegisElementProvider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public final class AegisJSONProvider
extends AegisElementProvider {
    private List<String> arrayKeys;
    private boolean serializeAsArray;
    private ConcurrentHashMap<String, String> namespaceMap = new ConcurrentHashMap();

    public void setArrayKeys(List<String> keys) {
        this.arrayKeys = keys;
    }

    public void setSerializeAsArray(boolean asArray) {
        this.serializeAsArray = asArray;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return false;
    }

    public void setNamespaceMap(Map<String, String> nsMap) {
        this.namespaceMap = new ConcurrentHashMap<String, String>(nsMap);
    }

    @Override
    protected XMLStreamWriter createStreamWriter(Class<?> type, OutputStream os) throws Exception {
        QName qname = this.getQName(type);
        if (this.writeXsiType) {
            this.namespaceMap.putIfAbsent("http://www.w3.org/2001/XMLSchema-instance", "xsins");
        }
        Configuration c = new Configuration(this.namespaceMap);
        MappedNamespaceConvention convention = new MappedNamespaceConvention(c);
        MappedXMLStreamWriter xsw = new MappedXMLStreamWriter(convention, (Writer)new OutputStreamWriter(os, "UTF-8"));
        if (this.serializeAsArray) {
            if (this.arrayKeys != null) {
                for (String key : this.arrayKeys) {
                    xsw.seriliazeAsArray(key);
                }
            } else {
                String key = this.getKey(convention, qname);
                xsw.seriliazeAsArray(key);
            }
        }
        return xsw;
    }

    @Override
    protected XMLStreamReader createStreamReader(Class<?> type, InputStream is) throws Exception {
        if (this.readXsiType) {
            this.namespaceMap.putIfAbsent("http://www.w3.org/2001/XMLSchema-instance", "xsins");
        }
        this.getQName(type);
        MappedXMLInputFactory factory = new MappedXMLInputFactory(this.namespaceMap);
        return new NamespaceContextReader(factory.createXMLStreamReader(is));
    }

    private QName getQName(Class<?> type) {
        QName qname = JAXRSUtils.getClassQName(type);
        this.namespaceMap.putIfAbsent(qname.getNamespaceURI(), "ns1");
        return qname;
    }

    private String getKey(MappedNamespaceConvention convention, QName qname) throws Exception {
        return convention.createKey(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    private class NamespaceContextReader
    extends DepthXMLStreamReader {
        public NamespaceContextReader(XMLStreamReader reader) {
            super(reader);
        }

        public NamespaceContext getNamespaceContext() {
            return new NamespaceContext(){

                public String getNamespaceURI(String prefix) {
                    for (Map.Entry entry : AegisJSONProvider.this.namespaceMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(prefix)) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                public String getPrefix(String ns) {
                    return (String)AegisJSONProvider.this.namespaceMap.get(ns);
                }

                public Iterator getPrefixes(String ns) {
                    String prefix = this.getPrefix(ns);
                    return prefix == null ? null : Collections.singletonList(prefix).iterator();
                }
            };
        }
    }
}

