/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.transport.http.WSDLQueryHandler;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHandlerRegistryImpl
implements QueryHandlerRegistry {
    List<QueryHandler> queryHandlers;
    Bus bus;

    public QueryHandlerRegistryImpl() {
    }

    public QueryHandlerRegistryImpl(Bus b, List<QueryHandler> handlers) {
        this.bus = b;
        this.queryHandlers = new CopyOnWriteArrayList<QueryHandler>(handlers);
    }

    public void setQueryHandlers(List<QueryHandler> handlers) {
        this.queryHandlers = new CopyOnWriteArrayList<QueryHandler>(handlers);
    }

    @PostConstruct
    public void register() {
        if (this.queryHandlers == null) {
            this.queryHandlers = new CopyOnWriteArrayList<QueryHandler>();
            if (this.bus != null) {
                WSDLQueryHandler wsdlQueryHandler = new WSDLQueryHandler();
                wsdlQueryHandler.setBus(this.bus);
                this.queryHandlers.add((QueryHandler)wsdlQueryHandler);
            }
        }
        if (null != this.bus) {
            this.bus.setExtension((Object)this, QueryHandlerRegistry.class);
        }
    }

    public List<QueryHandler> getHandlers() {
        return this.queryHandlers;
    }

    public void registerHandler(QueryHandler handler) {
        this.queryHandlers.add(handler);
    }

    public void registerHandler(QueryHandler handler, int position) {
        this.queryHandlers.add(position, handler);
    }

    @Resource
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }
}

