/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.Features;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InFaultInterceptors;
import org.apache.cxf.interceptor.InInterceptors;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutFaultInterceptors;
import org.apache.cxf.interceptor.OutInterceptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationInterceptors {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AnnotationInterceptors.class);
    private Class<?>[] clazzes;

    public AnnotationInterceptors(Class<?> ... clz) {
        this.clazzes = clz;
    }

    public List<Interceptor> getInFaultInterceptors() {
        return this.getAnnotationObject(InFaultInterceptors.class, Interceptor.class);
    }

    private <T> List<T> getAnnotationObject(Class<? extends Annotation> annotationClazz, Class<T> type) {
        for (Class<?> cls : this.clazzes) {
            Annotation annotation = cls.getAnnotation(annotationClazz);
            if (annotation == null) continue;
            return this.initializeAnnotationObjects(this.getAnnotationObjectNames(annotation), type);
        }
        return null;
    }

    private String[] getAnnotationObjectNames(Annotation ann) {
        if (ann instanceof InFaultInterceptors) {
            return ((InFaultInterceptors)ann).interceptors();
        }
        if (ann instanceof InInterceptors) {
            return ((InInterceptors)ann).interceptors();
        }
        if (ann instanceof OutFaultInterceptors) {
            return ((OutFaultInterceptors)ann).interceptors();
        }
        if (ann instanceof OutInterceptors) {
            return ((OutInterceptors)ann).interceptors();
        }
        if (ann instanceof Features) {
            return ((Features)ann).features();
        }
        throw new UnsupportedOperationException("Doesn't support the annotation: " + ann);
    }

    private <T> List<T> initializeAnnotationObjects(String[] annotationObjects, Class<T> type) {
        ArrayList<T> theAnnotationObjects = new ArrayList<T>();
        if (annotationObjects != null && annotationObjects.length > 0) {
            for (String annObjectName : annotationObjects) {
                Object object = null;
                try {
                    object = ClassLoaderUtils.loadClass((String)annObjectName, this.getClass()).newInstance();
                    theAnnotationObjects.add(type.cast(object));
                }
                catch (ClassNotFoundException e) {
                    throw new Fault(new Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, new Object[]{annObjectName}), (Throwable)e);
                }
                catch (InstantiationException ie) {
                    throw new Fault(new Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, new Object[]{annObjectName}), (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    throw new Fault(new Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, new Object[]{annObjectName}), (Throwable)iae);
                }
                catch (ClassCastException ex) {
                    throw new Fault(new Message("COULD_NOT_CREATE_ANNOTATION_OBJECT", BUNDLE, new Object[]{annObjectName}), (Throwable)ex);
                }
            }
        }
        return theAnnotationObjects;
    }

    public List<Interceptor> getInInterceptors() {
        return this.getAnnotationObject(InInterceptors.class, Interceptor.class);
    }

    public List<Interceptor> getOutFaultInterceptors() {
        return this.getAnnotationObject(OutFaultInterceptors.class, Interceptor.class);
    }

    public List<Interceptor> getOutInterceptors() {
        return this.getAnnotationObject(OutInterceptors.class, Interceptor.class);
    }

    public List<AbstractFeature> getFeatures() {
        return this.getAnnotationObject(Features.class, AbstractFeature.class);
    }
}

