/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.ClasspathScanner;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

class SpringClasspathScanner
extends ClasspathScanner {
    SpringClasspathScanner() throws Exception {
        Class.forName("org.springframework.core.io.support.PathMatchingResourcePatternResolver");
        Class.forName("org.springframework.core.type.classreading.CachingMetadataReaderFactory");
    }

    @Override
    protected Map<Class<? extends Annotation>, Collection<Class<?>>> findClassesInternal(Collection<String> basePackages, List<Class<? extends Annotation>> annotations) throws IOException, ClassNotFoundException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory factory = new CachingMetadataReaderFactory((ResourceLoader)resolver);
        HashMap classes = new HashMap();
        HashMap matchingInterfaces = new HashMap();
        HashMap<String, String[]> nonMatchingClasses = new HashMap<String, String[]>();
        for (Class<? extends Annotation> clazz : annotations) {
            classes.put(clazz, new HashSet());
            matchingInterfaces.put(clazz, new HashSet());
        }
        if (basePackages == null || basePackages.isEmpty()) {
            return classes;
        }
        for (String string : basePackages) {
            Resource[] resources;
            boolean scanAllPackages = string.equals("*");
            String packageSearchPath = "classpath*:" + (scanAllPackages ? "" : ClassUtils.convertClassNameToResourcePath((String)string)) + "**/*.class";
            for (Resource resource : resources = resolver.getResources(packageSearchPath)) {
                MetadataReader reader = factory.getMetadataReader(resource);
                AnnotationMetadata metadata = reader.getAnnotationMetadata();
                if (scanAllPackages && this.shouldSkip(metadata.getClassName())) continue;
                for (Class<? extends Annotation> annotation : annotations) {
                    boolean concreteClass;
                    boolean bl = concreteClass = !metadata.isInterface() && !metadata.isAbstract();
                    if (metadata.isAnnotated(annotation.getName())) {
                        if (concreteClass) {
                            ((Collection)classes.get(annotation)).add(ClassLoaderUtils.loadClass(metadata.getClassName(), this.getClass()));
                            continue;
                        }
                        ((Collection)matchingInterfaces.get(annotation)).add(metadata.getClassName());
                        continue;
                    }
                    if (!concreteClass || metadata.getInterfaceNames().length <= 0) continue;
                    nonMatchingClasses.put(metadata.getClassName(), metadata.getInterfaceNames());
                }
            }
        }
        for (Map.Entry entry : matchingInterfaces.entrySet()) {
            block5: for (Map.Entry e2 : nonMatchingClasses.entrySet()) {
                for (String intName : (String[])e2.getValue()) {
                    if (!((Collection)entry.getValue()).contains(intName)) continue;
                    ((Collection)classes.get(entry.getKey())).add(ClassLoaderUtils.loadClass((String)e2.getKey(), this.getClass()));
                    continue block5;
                }
            }
        }
        return classes;
    }

    @Override
    protected List<URL> findResourcesInternal(Collection<String> basePackages, String extension) throws IOException {
        ArrayList<URL> resourceURLs = new ArrayList<URL>();
        if (basePackages == null || basePackages.isEmpty()) {
            return resourceURLs;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (String basePackage : basePackages) {
            Resource[] resources;
            boolean scanAllPackages = basePackage.equals("*");
            String theBasePackage = basePackage;
            if (theBasePackage.startsWith("classpath:")) {
                theBasePackage = theBasePackage.substring("classpath:".length());
            }
            String packageSearchPath = "classpath*:" + (scanAllPackages ? "" : ClassUtils.convertClassNameToResourcePath((String)theBasePackage)) + "**/*" + "." + extension;
            for (Resource resource : resources = resolver.getResources(packageSearchPath)) {
                resourceURLs.add(resource.getURL());
            }
        }
        return resourceURLs;
    }

    private boolean shouldSkip(String classname) {
        for (String packageToSkip : PACKAGES_TO_SKIP) {
            if (!classname.startsWith(packageToSkip)) continue;
            return true;
        }
        return false;
    }
}

