/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaMethod;

public class SoapBindingAnnotator
implements Annotator {
    @Override
    public void annotate(JavaAnnotatable ja) {
        if (!(ja instanceof JavaMethod)) {
            throw new RuntimeException("SOAPBindingAnnotator can only annotate JavaMethod");
        }
        JavaMethod method = (JavaMethod)ja;
        if (method.getSoapStyle() == SOAPBinding.Style.DOCUMENT) {
            if (!method.isWrapperStyle() && !SOAPBinding.ParameterStyle.BARE.equals((Object)method.getInterface().getSOAPParameterStyle())) {
                JAnnotation bindingAnnotation = new JAnnotation(SOAPBinding.class);
                bindingAnnotation.addElement(new JAnnotationElement("parameterStyle", SOAPBinding.ParameterStyle.BARE));
                method.addAnnotation("SOAPBinding", bindingAnnotation);
            } else if (method.isWrapperStyle() && SOAPBinding.ParameterStyle.BARE.equals((Object)method.getInterface().getSOAPParameterStyle())) {
                JAnnotation bindingAnnotation = new JAnnotation(SOAPBinding.class);
                bindingAnnotation.addElement(new JAnnotationElement("parameterStyle", SOAPBinding.ParameterStyle.WRAPPED));
                method.addAnnotation("SOAPBinding", bindingAnnotation);
            }
        } else if (!SOAPBinding.Style.RPC.equals((Object)method.getInterface().getSOAPStyle())) {
            JAnnotation bindingAnnotation = new JAnnotation(SOAPBinding.class);
            bindingAnnotation.addElement(new JAnnotationElement("style", SOAPBinding.Style.RPC));
            method.addAnnotation("SOAPBinding", bindingAnnotation);
        }
    }
}

