/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.clustering;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.clustering.AbstractStaticFailoverStrategy;
import org.apache.cxf.clustering.FailoverStrategy;
import org.apache.cxf.clustering.SequentialStrategy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.AbstractConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.Retryable;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.transport.Conduit;

public class FailoverTargetSelector
extends AbstractConduitSelector {
    private static final Logger LOG = LogUtils.getL7dLogger(FailoverTargetSelector.class);
    protected ConcurrentHashMap<InvocationKey, InvocationContext> inProgress = new ConcurrentHashMap();
    protected FailoverStrategy failoverStrategy;

    public FailoverTargetSelector() {
    }

    public FailoverTargetSelector(Conduit c) {
        super(c);
    }

    @Override
    public void prepare(Message message) {
        if (message.getContent(List.class) == null) {
            return;
        }
        Exchange exchange = message.getExchange();
        InvocationKey key = new InvocationKey(exchange);
        if (!this.inProgress.containsKey(key)) {
            Endpoint endpoint = exchange.get(Endpoint.class);
            BindingOperationInfo bindingOperationInfo = exchange.getBindingOperationInfo();
            Object[] params = message.getContent(List.class).toArray();
            Map<String, Object> context = CastUtils.cast((Map)message.get("org.apache.cxf.invocation.context"));
            InvocationContext invocation = new InvocationContext(endpoint, bindingOperationInfo, params, context);
            this.inProgress.putIfAbsent(key, invocation);
        }
    }

    @Override
    public Conduit selectConduit(Message message) {
        Conduit c = message.get(Conduit.class);
        if (c != null) {
            return c;
        }
        return this.getSelectedConduit(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Exchange exchange) {
        InvocationKey key = new InvocationKey(exchange);
        InvocationContext invocation = null;
        FailoverTargetSelector failoverTargetSelector = this;
        synchronized (failoverTargetSelector) {
            invocation = this.inProgress.get(key);
        }
        boolean failover = false;
        if (this.requiresFailover(exchange)) {
            Conduit old = (Conduit)exchange.getOutMessage().remove(Conduit.class.getName());
            Endpoint failoverTarget = this.getFailoverTarget(exchange, invocation);
            if (failoverTarget != null) {
                this.setEndpoint(failoverTarget);
                if (old != null) {
                    old.close();
                    this.conduits.remove(old);
                }
                Exception prevExchangeFault = (Exception)exchange.remove(Exception.class.getName());
                Message outMessage = exchange.getOutMessage();
                Exception prevMessageFault = outMessage.getContent(Exception.class);
                outMessage.setContent(Exception.class, null);
                this.overrideAddressProperty(invocation.getContext());
                Retryable retry = exchange.get(Retryable.class);
                exchange.clear();
                if (retry != null) {
                    try {
                        failover = true;
                        long delay = this.getDelayBetweenRetries();
                        if (delay > 0L) {
                            Thread.sleep(delay);
                        }
                        retry.invoke(invocation.getBindingOperationInfo(), invocation.getParams(), invocation.getContext(), exchange);
                    }
                    catch (Exception e) {
                        if (exchange.get(Exception.class) != null) {
                            exchange.put(Exception.class, prevExchangeFault);
                        }
                        if (outMessage.getContent(Exception.class) != null) {
                            outMessage.setContent(Exception.class, prevMessageFault);
                        }
                    }
                }
            } else {
                this.setEndpoint(invocation.retrieveOriginalEndpoint(this.endpoint));
            }
        }
        if (!failover) {
            this.getLogger().fine("FAILOVER_NOT_REQUIRED");
            FailoverTargetSelector failoverTargetSelector2 = this;
            synchronized (failoverTargetSelector2) {
                this.inProgress.remove(key);
            }
            super.complete(exchange);
        }
    }

    public synchronized void setStrategy(FailoverStrategy strategy) {
        if (strategy != null) {
            this.getLogger().log(Level.INFO, "USING_STRATEGY", new Object[]{strategy});
            this.failoverStrategy = strategy;
        }
    }

    public synchronized FailoverStrategy getStrategy() {
        if (this.failoverStrategy == null) {
            this.failoverStrategy = new SequentialStrategy();
            this.getLogger().log(Level.INFO, "USING_STRATEGY", new Object[]{this.failoverStrategy});
        }
        return this.failoverStrategy;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    protected long getDelayBetweenRetries() {
        FailoverStrategy strategy = this.getStrategy();
        if (strategy instanceof AbstractStaticFailoverStrategy) {
            return ((AbstractStaticFailoverStrategy)strategy).getDelayBetweenRetries();
        }
        return 0L;
    }

    protected boolean requiresFailover(Exchange exchange) {
        Message outMessage = exchange.getOutMessage();
        Exception ex = outMessage.get(Exception.class) != null ? outMessage.get(Exception.class) : exchange.get(Exception.class);
        this.getLogger().log(Level.FINE, "CHECK_LAST_INVOKE_FAILED", new Object[]{ex != null});
        boolean failover = false;
        for (Throwable curr = ex; curr != null; curr = curr.getCause()) {
            failover = curr instanceof IOException;
        }
        if (ex != null) {
            this.getLogger().log(Level.INFO, "CHECK_FAILURE_IN_TRANSPORT", new Object[]{ex, failover});
        }
        return failover;
    }

    protected Endpoint getFailoverTarget(Exchange exchange, InvocationContext invocation) {
        List<String> alternateAddresses = null;
        if (!invocation.hasAlternates()) {
            alternateAddresses = this.getStrategy().getAlternateAddresses(exchange);
            if (alternateAddresses != null) {
                invocation.setAlternateAddresses(alternateAddresses);
            } else {
                invocation.setAlternateEndpoints(this.getStrategy().getAlternateEndpoints(exchange));
            }
        } else {
            alternateAddresses = invocation.getAlternateAddresses();
        }
        Endpoint failoverTarget = null;
        if (alternateAddresses != null) {
            String alternateAddress = this.getStrategy().selectAlternateAddress(alternateAddresses);
            if (alternateAddress != null) {
                failoverTarget = this.getEndpoint();
                failoverTarget.getEndpointInfo().setAddress(alternateAddress);
            }
        } else {
            failoverTarget = this.getStrategy().selectAlternateEndpoint(invocation.getAlternateEndpoints());
        }
        return failoverTarget;
    }

    protected void overrideAddressProperty(Map<String, Object> context) {
        this.overrideAddressProperty(context, this.getEndpoint().getEndpointInfo().getAddress());
    }

    protected void overrideAddressProperty(Map<String, Object> context, String address) {
        Map requestContext = CastUtils.cast((Map)context.get("RequestContext"));
        if (requestContext != null) {
            requestContext.put(Message.ENDPOINT_ADDRESS, address);
            requestContext.put("javax.xml.ws.service.endpoint.address", address);
        }
    }

    @Override
    protected boolean replaceEndpointAddressPropertyIfNeeded(Message message, String endpointAddress, Conduit cond) {
        String basePath;
        String requestURI = (String)message.get("org.apache.cxf.request.uri");
        if (requestURI != null && endpointAddress != null && !requestURI.equals(endpointAddress) && (basePath = (String)message.get(Message.BASE_PATH)) != null && requestURI.startsWith(basePath)) {
            String pathInfo = requestURI.substring(basePath.length());
            message.put(Message.BASE_PATH, endpointAddress);
            String slash = "/";
            boolean startsWithSlash = pathInfo.startsWith("/");
            endpointAddress = endpointAddress.endsWith("/") ? endpointAddress + (startsWithSlash ? pathInfo.substring(1) : pathInfo) : endpointAddress + (startsWithSlash ? pathInfo : "/" + pathInfo);
            message.put(Message.ENDPOINT_ADDRESS, endpointAddress);
            Exchange exchange = message.getExchange();
            InvocationKey key = new InvocationKey(exchange);
            InvocationContext invocation = this.inProgress.get(key);
            if (invocation != null) {
                this.overrideAddressProperty(invocation.getContext(), cond.getTarget().getAddress().getValue());
            }
            return true;
        }
        return false;
    }

    protected class InvocationContext {
        private Endpoint originalEndpoint;
        private String originalAddress;
        private BindingOperationInfo bindingOperationInfo;
        private Object[] params;
        private Map<String, Object> context;
        private List<Endpoint> alternateEndpoints;
        private List<String> alternateAddresses;

        InvocationContext(Endpoint endpoint, BindingOperationInfo boi, Object[] prms, Map<String, Object> ctx) {
            this.originalEndpoint = endpoint;
            this.originalAddress = endpoint.getEndpointInfo().getAddress();
            this.bindingOperationInfo = boi;
            this.params = prms;
            this.context = ctx;
        }

        Endpoint retrieveOriginalEndpoint(Endpoint endpoint) {
            if (endpoint != null) {
                if (endpoint != this.originalEndpoint) {
                    FailoverTargetSelector.this.getLogger().log(Level.INFO, "REVERT_TO_ORIGINAL_TARGET", endpoint.getEndpointInfo().getName());
                }
                if (!endpoint.getEndpointInfo().getAddress().equals(this.originalAddress)) {
                    endpoint.getEndpointInfo().setAddress(this.originalAddress);
                    FailoverTargetSelector.this.getLogger().log(Level.INFO, "REVERT_TO_ORIGINAL_ADDRESS", endpoint.getEndpointInfo().getAddress());
                }
            }
            return this.originalEndpoint;
        }

        BindingOperationInfo getBindingOperationInfo() {
            return this.bindingOperationInfo;
        }

        Object[] getParams() {
            return this.params;
        }

        Map<String, Object> getContext() {
            return this.context;
        }

        List<Endpoint> getAlternateEndpoints() {
            return this.alternateEndpoints;
        }

        List<String> getAlternateAddresses() {
            return this.alternateAddresses;
        }

        void setAlternateEndpoints(List<Endpoint> alternates) {
            this.alternateEndpoints = alternates;
        }

        void setAlternateAddresses(List<String> alternates) {
            this.alternateAddresses = alternates;
        }

        boolean hasAlternates() {
            return this.alternateEndpoints != null || this.alternateAddresses != null;
        }
    }

    protected static class InvocationKey {
        private Exchange exchange;

        InvocationKey(Exchange ex) {
            this.exchange = ex;
        }

        public int hashCode() {
            return System.identityHashCode(this.exchange);
        }

        public boolean equals(Object o) {
            return o instanceof InvocationKey && this.exchange == ((InvocationKey)o).exchange;
        }
    }
}

