/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.redis.CommandDispatcher;
import org.apache.camel.component.redis.RedisClient;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.URISupport;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisProducer
extends DefaultProducer {
    private final RedisClient redisClient;
    private transient String redisProducerToString;

    public RedisProducer(RedisEndpoint endpoint, RedisConfiguration configuration) {
        super((Endpoint)endpoint);
        this.redisClient = new RedisClient((RedisTemplate<String, Object>)configuration.getRedisTemplate());
    }

    public void process(Exchange exchange) throws Exception {
        new CommandDispatcher(this.getConfiguration(), exchange).execute(this.redisClient);
    }

    protected RedisConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public RedisEndpoint getEndpoint() {
        return (RedisEndpoint)super.getEndpoint();
    }

    public String toString() {
        if (this.redisProducerToString == null) {
            this.redisProducerToString = "RedisProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.redisProducerToString;
    }
}

