/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.trace;

import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CalciteTimingTracer {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###,###,###,###");
    private final Logger logger;
    private long lastNanoTime;

    public CalciteTimingTracer(Logger logger, String startEvent) {
        if (!logger.isLoggable(Level.FINE)) {
            this.logger = null;
            return;
        }
        this.logger = logger;
        this.lastNanoTime = System.nanoTime();
        logger.fine(startEvent + ":  elapsed nanos=0");
    }

    public void traceTime(String event) {
        if (this.logger == null) {
            return;
        }
        long newNanoTime = System.nanoTime();
        long elapsed = newNanoTime - this.lastNanoTime;
        this.lastNanoTime = newNanoTime;
        this.logger.fine(event + ":  elapsed nanos=" + DECIMAL_FORMAT.format(elapsed));
    }
}

