/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.RelCompositeTrait;
import org.apache.calcite.plan.RelMultipleTrait;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;

public abstract class RelTraitDef<T extends RelTrait> {
    private final LoadingCache<T, T> canonicalMap = CacheBuilder.newBuilder().softValues().build(new CacheLoader<T, T>(){

        public T load(@Nonnull T key) throws Exception {
            return key;
        }
    });
    private final LoadingCache<Object, RelCompositeTrait> canonicalCompositeMap = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<Object, RelCompositeTrait>(){

        public RelCompositeTrait load(@Nonnull Object key) {
            if (key instanceof RelCompositeTrait) {
                return (RelCompositeTrait)key;
            }
            List list = (List)key;
            RelTraitDef def = ((RelMultipleTrait)list.get(0)).getTraitDef();
            return RelCompositeTrait.of(def, list);
        }
    });

    protected RelTraitDef() {
    }

    public boolean multiple() {
        return false;
    }

    public abstract Class<T> getTraitClass();

    public abstract String getSimpleName();

    public final T canonize(T trait) {
        if (trait instanceof RelCompositeTrait) {
            RelCompositeTrait relCompositeTrait = (RelCompositeTrait)trait;
            return (T)this.canonizeComposite(relCompositeTrait);
        }
        assert (this.getTraitClass().isInstance(trait)) : this.getClass().getName() + " cannot canonize a " + trait.getClass().getName();
        return (T)((RelTrait)this.canonicalMap.getUnchecked(trait));
    }

    final RelCompositeTrait canonizeComposite(RelCompositeTrait compositeTrait) {
        return (RelCompositeTrait)this.canonicalCompositeMap.getUnchecked((Object)compositeTrait);
    }

    public abstract RelNode convert(RelOptPlanner var1, RelNode var2, T var3, boolean var4);

    public abstract boolean canConvert(RelOptPlanner var1, T var2, T var3);

    public void registerConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
    }

    public void deregisterConverterRule(RelOptPlanner planner, ConverterRule converterRule) {
    }

    public abstract T getDefault();
}

