define([ "require", "backbone", "hbs!tmpl/site/Statistics_tmpl", "modules/Modal", "models/VCommon", "utils/UrlLinks", "collection/VTagList", "utils/CommonViewFunction" ], function(require, Backbone, StatTmpl, Modal, VCommon, UrlLinks, VTagList, CommonViewFunction) {
    "use strict";
    var StatisticsView = Backbone.Marionette.LayoutView.extend({
        template: StatTmpl,
        regions: {},
        ui: {
            entityActive: "[data-id='entityActive'] tbody",
            entityDelete: "[data-id='entityDelete'] tbody",
            entityActiveHeader: "[data-id='entityActive'] .count",
            entityDeletedHeader: "[data-id='entityDelete'] .count"
        },
        events: function() {},
        initialize: function(options) {
            _.extend(this, options);
            var modal = new Modal({
                title: "Statistics",
                content: this,
                okCloses: !0,
                showFooter: !0,
                allowCancel: !1
            }).open();
            modal.on("closeModal", function() {
                modal.trigger("cancel");
            });
        },
        bindEvents: function() {},
        onRender: function() {
            var that = this, entityCountCollection = new VTagList();
            entityCountCollection.url = UrlLinks.entityCountApi(), entityCountCollection.modelAttrName = "data", 
            entityCountCollection.fetch({
                success: function(data) {
                    var data = _.first(data.toJSON()), no_records = '<tr class="empty text-center"><td colspan="2"><span>No records found!</span></td></tr>', activeEntityTable = _.isEmpty(data.entity.entityActive) ? no_records : that.getTable({
                        valueObject: data.entity.entityActive
                    }), deleteEntityTable = _.isEmpty(data.entity.entityDeleted) ? no_records : that.getTable({
                        valueObject: data.entity.entityDeleted
                    }), totalActive = 0, totalDeleted = 0;
                    data.entity && data.general.entityCount && (totalActive = data.general.entityCount), 
                    data.entity && data.entity.entityDeleted && _.each(data.entity.entityDeleted, function(val) {
                        totalDeleted += val;
                    }), that.ui.entityActive.html(activeEntityTable), that.ui.entityDelete.html(deleteEntityTable), 
                    that.ui.entityActiveHeader.html("&nbsp;(" + _.numberFormatWithComa(totalActive - totalDeleted) + ")"), 
                    that.ui.entityDeletedHeader.html("&nbsp;(" + _.numberFormatWithComa(totalDeleted) + ")");
                }
            });
        },
        getTable: function(obj) {
            return CommonViewFunction.propertyTable(_.extend({
                scope: this,
                formatIntVal: !0
            }, obj));
        }
    });
    return StatisticsView;
});